/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class MLDeleteWorkingMemoryRequest
extends ActionRequest {
    private String memoryContainerId;
    private String workingMemoryId;

    public MLDeleteWorkingMemoryRequest(String memoryContainerId, String workingMemoryId) {
        this.memoryContainerId = memoryContainerId;
        this.workingMemoryId = workingMemoryId;
    }

    public MLDeleteWorkingMemoryRequest(StreamInput in) throws IOException {
        super(in);
        this.memoryContainerId = in.readString();
        this.workingMemoryId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.memoryContainerId);
        out.writeString(this.workingMemoryId);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.memoryContainerId == null || this.memoryContainerId.isEmpty()) {
            exception = new ActionRequestValidationException();
            exception.addValidationError("Memory container id is required");
        }
        if (this.workingMemoryId == null || this.workingMemoryId.isEmpty()) {
            if (exception == null) {
                exception = new ActionRequestValidationException();
            }
            exception.addValidationError("Working memory id is required");
        }
        return exception;
    }

    @Generated
    public static MLDeleteWorkingMemoryRequestBuilder builder() {
        return new MLDeleteWorkingMemoryRequestBuilder();
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public String getWorkingMemoryId() {
        return this.workingMemoryId;
    }

    @Generated
    public static class MLDeleteWorkingMemoryRequestBuilder {
        @Generated
        private String memoryContainerId;
        @Generated
        private String workingMemoryId;

        @Generated
        MLDeleteWorkingMemoryRequestBuilder() {
        }

        @Generated
        public MLDeleteWorkingMemoryRequestBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLDeleteWorkingMemoryRequestBuilder workingMemoryId(String workingMemoryId) {
            this.workingMemoryId = workingMemoryId;
            return this;
        }

        @Generated
        public MLDeleteWorkingMemoryRequest build() {
            return new MLDeleteWorkingMemoryRequest(this.memoryContainerId, this.workingMemoryId);
        }

        @Generated
        public String toString() {
            return "MLDeleteWorkingMemoryRequest.MLDeleteWorkingMemoryRequestBuilder(memoryContainerId=" + this.memoryContainerId + ", workingMemoryId=" + this.workingMemoryId + ")";
        }
    }
}

