/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.cv.Image;
import ai.djl.ndarray.NDArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageFactory {
    private static final Logger logger = LoggerFactory.getLogger(ImageFactory.class);
    private static final String[] FACTORIES = new String[]{"ai.djl.opencv.OpenCVImageFactory", "ai.djl.modality.cv.BufferedImageFactory", "ai.djl.android.core.BitmapImageFactory"};
    private static final Pattern URL_PATTERN = Pattern.compile("^data:image/\\w+;base64,(.+)");
    private static ImageFactory factory = ImageFactory.newInstance();

    private static ImageFactory newInstance() {
        int index = 0;
        if ("http://www.android.com/".equals(System.getProperty("java.vendor.url"))) {
            index = 2;
        }
        for (int i = index; i < FACTORIES.length; ++i) {
            try {
                Class<ImageFactory> clazz = Class.forName(FACTORIES[i]).asSubclass(ImageFactory.class);
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ExceptionInInitializerError | ReflectiveOperationException e) {
                logger.trace("", e);
                continue;
            }
        }
        throw new IllegalStateException("Create new ImageFactory failed!");
    }

    public static ImageFactory getInstance() {
        return factory;
    }

    public static void setImageFactory(ImageFactory factory) {
        ImageFactory.factory = factory;
    }

    public abstract Image fromFile(Path var1) throws IOException;

    public Image fromUrl(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            Image image = this.fromInputStream(is);
            return image;
        }
    }

    public Image fromUrl(String url) throws IOException {
        Matcher m = URL_PATTERN.matcher(url);
        if (m.matches()) {
            byte[] buf = Base64.getDecoder().decode(m.group(1));
            try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
                Image image = this.fromInputStream(is);
                return image;
            }
        }
        URI uri = URI.create(url);
        if (uri.isAbsolute()) {
            return this.fromUrl(uri.toURL());
        }
        return this.fromFile(Paths.get(url, new String[0]));
    }

    public abstract Image fromInputStream(InputStream var1) throws IOException;

    public abstract Image fromImage(Object var1);

    public abstract Image fromNDArray(NDArray var1);

    public abstract Image fromPixels(int[] var1, int var2, int var3);
}

