/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.model.SearchParams;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.searchrelevance.transport.scheduledJob.GetScheduledExperimentAction;
import org.opensearch.searchrelevance.utils.ParserUtils;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestGetScheduledExperimentAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestGetScheduledExperimentAction.class);
    private static final String GET_SCHEDULED_EXPERIMENT_ACTION = "get_scheduled_experiment_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return GET_SCHEDULED_EXPERIMENT_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_search_relevance/experiments/schedule", "id")), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_search_relevance/experiments/schedule"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        if (!this.settingsAccessor.isScheduledExperimentsEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Scheduled experiments is disabled"));
        }
        String jobId = request.param("id");
        if (jobId != null && !jobId.isEmpty()) {
            OpenSearchDocRequest getRequest = new OpenSearchDocRequest(jobId);
            return this.executeGetRequest(client, getRequest);
        }
        SearchParams searchParams = ParserUtils.parseSearchParams(request);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(searchParams.getSize()).sort(searchParams.getSortField(), searchParams.getSortOrder());
        OpenSearchDocRequest getRequest = new OpenSearchDocRequest(searchSourceBuilder);
        return this.executeGetRequest(client, getRequest);
    }

    private BaseRestHandler.RestChannelConsumer executeGetRequest(NodeClient client, OpenSearchDocRequest request) {
        return channel -> client.execute((ActionType)GetScheduledExperimentAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    RestStatus status = response.status();
                    channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestGetScheduledExperimentAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

