/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss.reconstruct;

import lombok.Generated;
import org.opensearch.knn.memoryoptsearch.faiss.UnsupportedFaissIndexException;
import org.opensearch.knn.memoryoptsearch.faiss.reconstruct.Faiss8BitsDirectSignedReconstructor;
import org.opensearch.knn.memoryoptsearch.faiss.reconstruct.FaissFP16Reconstructor;
import org.opensearch.knn.memoryoptsearch.faiss.reconstruct.FaissQuantizedValueReconstructor;
import org.opensearch.knn.memoryoptsearch.faiss.reconstruct.FaissQuantizerType;

public final class FaissQuantizedValueReconstructorFactory {
    public static FaissQuantizedValueReconstructor create(FaissQuantizerType quantizerType, int dimension, int numOneVectorBits) {
        if (quantizerType == FaissQuantizerType.QT_8BIT_DIRECT_SIGNED) {
            return new Faiss8BitsDirectSignedReconstructor(dimension, numOneVectorBits);
        }
        if (quantizerType == FaissQuantizerType.QT_FP16) {
            return new FaissFP16Reconstructor(dimension, numOneVectorBits);
        }
        throw new UnsupportedFaissIndexException("Unsupported quantizer type: " + String.valueOf((Object)quantizerType));
    }

    @Generated
    private FaissQuantizedValueReconstructorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

