/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.caching.CacheProvider;
import org.opensearch.timeseries.caching.TimeSeriesCache;
import org.opensearch.timeseries.cluster.HashRing;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.EntityProfileName;
import org.opensearch.timeseries.model.ModelProfile;
import org.opensearch.timeseries.model.ModelProfileOnNode;
import org.opensearch.timeseries.transport.EntityProfileRequest;
import org.opensearch.timeseries.transport.EntityProfileResponse;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class BaseEntityProfileTransportAction<RCFModelType extends ThresholdedRandomCutForest, CacheType extends TimeSeriesCache<RCFModelType>, CacheProviderType extends CacheProvider<RCFModelType, CacheType>>
extends HandledTransportAction<EntityProfileRequest, EntityProfileResponse> {
    private static final Logger LOG = LogManager.getLogger(BaseEntityProfileTransportAction.class);
    public static final String NO_NODE_FOUND_MSG = "Cannot find model hosting node";
    public static final String NO_MODEL_ID_FOUND_MSG = "Cannot find model id";
    static final String FAIL_TO_GET_ENTITY_PROFILE_MSG = "Cannot get entity profile info";
    private final TransportService transportService;
    private final HashRing hashRing;
    private final TransportRequestOptions option;
    private final ClusterService clusterService;
    private final CacheProviderType cacheProvider;
    private final String entityProfileAction;

    public BaseEntityProfileTransportAction(ActionFilters actionFilters, TransportService transportService, Settings settings, HashRing hashRing, ClusterService clusterService, CacheProviderType cacheProvider, String entityProfileAction, Setting<TimeValue> requestTimeOut) {
        super(entityProfileAction, transportService, actionFilters, EntityProfileRequest::new);
        this.transportService = transportService;
        this.hashRing = hashRing;
        this.option = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.REG).withTimeout((TimeValue)requestTimeOut.get(settings)).build();
        this.clusterService = clusterService;
        this.cacheProvider = cacheProvider;
        this.entityProfileAction = entityProfileAction;
    }

    protected void doExecute(Task task, EntityProfileRequest request, final ActionListener<EntityProfileResponse> listener) {
        String adID = request.getConfigID();
        Entity entityValue = request.getEntityValue();
        Optional<String> modelIdOptional = entityValue.getModelId(adID);
        if (!modelIdOptional.isPresent()) {
            listener.onFailure((Exception)new TimeSeriesException(adID, NO_MODEL_ID_FOUND_MSG));
            return;
        }
        Optional<DiscoveryNode> node = this.hashRing.getOwningNodeWithSameLocalVersionForRealtime(entityValue.toString());
        if (!node.isPresent()) {
            listener.onFailure((Exception)new TimeSeriesException(adID, NO_NODE_FOUND_MSG));
            return;
        }
        String nodeId = node.get().getId();
        String modelId = modelIdOptional.get();
        DiscoveryNode localNode = this.clusterService.localNode();
        if (localNode.getId().equals(nodeId)) {
            Optional<ModelProfile> modleProfile;
            Object cache = ((CacheProvider)this.cacheProvider).get();
            Set<EntityProfileName> profilesToCollect = request.getProfilesToCollect();
            EntityProfileResponse.Builder builder = new EntityProfileResponse.Builder();
            if (profilesToCollect.contains(EntityProfileName.ENTITY_INFO)) {
                builder.setActive(cache.isActive(adID, modelId));
                builder.setLastActiveMs(cache.getLastActiveTime(adID, modelId));
            }
            if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS) || profilesToCollect.contains(EntityProfileName.STATE)) {
                builder.setTotalUpdates(cache.getTotalUpdates(adID, modelId));
            }
            if (profilesToCollect.contains(EntityProfileName.MODELS) && (modleProfile = cache.getModelProfile(adID, modelId)).isPresent()) {
                builder.setModelProfile(new ModelProfileOnNode(nodeId, modleProfile.get()));
            }
            listener.onResponse((Object)builder.build());
        } else if (request.remoteAddress() == null) {
            LOG.info("Sending entity profile request to {} for detector {}, entity {}", (Object)nodeId, (Object)adID, (Object)entityValue);
            try {
                this.transportService.sendRequest(node.get(), this.entityProfileAction, (TransportRequest)request, this.option, (TransportResponseHandler)new TransportResponseHandler<EntityProfileResponse>(){

                    public EntityProfileResponse read(StreamInput in) throws IOException {
                        return new EntityProfileResponse(in);
                    }

                    public void handleResponse(EntityProfileResponse response) {
                        listener.onResponse((Object)response);
                    }

                    public void handleException(TransportException exp) {
                        listener.onFailure((Exception)exp);
                    }

                    public String executor() {
                        return "same";
                    }
                });
            }
            catch (Exception e) {
                LOG.error(String.format(Locale.ROOT, "Fail to get entity profile for detector {}, entity {}", adID, entityValue), (Throwable)e);
                listener.onFailure((Exception)new TimeSeriesException(adID, FAIL_TO_GET_ENTITY_PROFILE_MSG, e));
            }
        } else {
            LOG.error("Fail to get entity profile for detector {}, entity {}. Maybe because old and new node are using different keys for the hash ring.", (Object)adID, (Object)entityValue);
            listener.onFailure((Exception)new TimeSeriesException(adID, FAIL_TO_GET_ENTITY_PROFILE_MSG));
        }
    }
}

