/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class CountAggregator
extends Aggregator<CountState> {
    public CountAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.COUNT.getName(), arguments, returnType);
    }

    @Override
    public CountState create() {
        return this.distinct != false ? new DistinctCountState() : new CountState();
    }

    @Override
    protected CountState iterate(ExprValue value, CountState state) {
        state.count(value);
        return state;
    }

    public String toString() {
        return this.distinct != false ? String.format(Locale.ROOT, "count(distinct %s)", ExpressionUtils.format(this.getArguments())) : String.format(Locale.ROOT, "count(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class DistinctCountState
    extends CountState {
        private final Set<ExprValue> distinctValues = new HashSet<ExprValue>();

        protected DistinctCountState() {
        }

        @Override
        public void count(ExprValue value) {
            if (!this.distinctValues.contains(value)) {
                this.distinctValues.add(value);
                ++this.count;
            }
        }
    }

    protected static class CountState
    implements AggregationState {
        protected long count = 0L;

        CountState() {
        }

        public void count(ExprValue value) {
            ++this.count;
        }

        @Override
        public ExprValue result() {
            return ExprValueUtils.longValue(this.count);
        }
    }
}

