/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

@Incubating
public interface Initializer<Data extends InitializerData> {
    public static final Initializer<?>[] EMPTY_ARRAY;

    default public @Nullable InitializerParent<?> getParent() {
        return null;
    }

    default public @Nullable EntityInitializer<?> findOwningEntityInitializer() {
        return Initializer.findOwningEntityInitializer(this.getParent());
    }

    public static @Nullable EntityInitializer<?> findOwningEntityInitializer(@Nullable Initializer<?> parent) {
        if (parent == null || parent.isCollectionInitializer()) {
            return null;
        }
        EntityInitializer<?> initializer = parent.asEntityInitializer();
        return initializer != null ? initializer : Initializer.findOwningEntityInitializer(parent.getParent());
    }

    public NavigablePath getNavigablePath();

    public ModelPart getInitializedPart();

    default public Object getResolvedInstance(Data data) {
        block5: {
            if (1.$assertionsDisabled) break block5;
            switch (((InitializerData)data).getState().ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    break block5;
                }
                case 1: {
                    if (((InitializerData)data).getInstance() == null) break block5;
                }
            }
            throw new AssertionError();
        }
        return ((InitializerData)data).getInstance();
    }

    default public Object getResolvedInstance(RowProcessingState rowProcessingState) {
        return this.getResolvedInstance(this.getData(rowProcessingState));
    }

    public Data getData(RowProcessingState var1);

    public void startLoading(RowProcessingState var1);

    public void resolveKey(Data var1);

    default public void resolveKey(RowProcessingState rowProcessingState) {
        this.resolveKey(this.getData(rowProcessingState));
    }

    default public void resolveFromPreviousRow(Data data) {
        this.resolveKey(data);
    }

    default public void resolveFromPreviousRow(RowProcessingState rowProcessingState) {
        this.resolveFromPreviousRow(this.getData(rowProcessingState));
    }

    public void resolveInstance(Data var1);

    default public void resolveInstance(RowProcessingState rowProcessingState) {
        this.resolveInstance(this.getData(rowProcessingState));
    }

    public void resolveState(Data var1);

    default public void resolveState(RowProcessingState rowProcessingState) {
        this.resolveState(this.getData(rowProcessingState));
    }

    default public void resolveInstance(@Nullable Object instance, Data data) {
        this.resolveKey(data);
    }

    default public void resolveInstance(@Nullable Object instance, RowProcessingState rowProcessingState) {
        this.resolveInstance(instance, this.getData(rowProcessingState));
    }

    public void initializeInstance(Data var1);

    default public void initializeInstance(RowProcessingState rowProcessingState) {
        this.initializeInstance(this.getData(rowProcessingState));
    }

    default public void initializeInstanceFromParent(Object parentInstance, Data data) {
    }

    default public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        this.initializeInstanceFromParent(parentInstance, this.getData(rowProcessingState));
    }

    public void finishUpRow(Data var1);

    default public void endLoading(Data data) {
    }

    public boolean isPartOfKey();

    public static boolean isPartOfKey(NavigablePath navigablePath, InitializerParent<?> parent) {
        return parent != null && parent.isEmbeddableInitializer() && parent.isPartOfKey() || navigablePath instanceof EntityIdentifierNavigablePath || "{fk}".equals(navigablePath.getLocalName()) || "{fk-target}".equals(navigablePath.getLocalName());
    }

    public boolean isEager();

    default public boolean isLazyCapable() {
        return true;
    }

    public boolean hasLazySubInitializers();

    public boolean isResultInitializer();

    default public boolean isEmbeddableInitializer() {
        return false;
    }

    default public boolean isEntityInitializer() {
        return false;
    }

    default public boolean isCollectionInitializer() {
        return false;
    }

    default public @Nullable EntityInitializer<?> asEntityInitializer() {
        return null;
    }

    default public @Nullable EmbeddableInitializer<?> asEmbeddableInitializer() {
        return null;
    }

    default public @Nullable CollectionInitializer<?> asCollectionInitializer() {
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY_ARRAY = new Initializer[0];
    }

    public static enum State {
        UNINITIALIZED,
        MISSING,
        KEY_RESOLVED,
        RESOLVED,
        INITIALIZED;

    }
}

