/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate26_0_0_IdentityProviderAttributesMigration
extends CustomKeycloakTask {
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String value;
        String id;
        ResultSet resultSet;
        PreparedStatement ps;
        try {
            ps = this.connection.prepareStatement("SELECT c.IDENTITY_PROVIDER_ID, c.VALUE  FROM " + this.getTableName("IDENTITY_PROVIDER_CONFIG") + " c WHERE c.NAME = 'kc.org'");
            try {
                resultSet = ps.executeQuery();
                try {
                    while (resultSet.next()) {
                        id = resultSet.getString(1);
                        value = resultSet.getString(2);
                        this.statements.add(new UpdateStatement(null, null, this.database.correctObjectName("IDENTITY_PROVIDER", Table.class)).addNewColumnValue("ORGANIZATION_ID", (Object)value).setWhereClause("INTERNAL_ID=?").addWhereParameter((Object)id));
                    }
                    this.statements.add(new DeleteStatement(null, null, this.database.correctObjectName("IDENTITY_PROVIDER_CONFIG", Table.class)).setWhere("NAME=?").addWhereParameter((Object)"kc.org"));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
        try {
            ps = this.connection.prepareStatement("SELECT c.IDENTITY_PROVIDER_ID, c.VALUE  FROM " + this.getTableName("IDENTITY_PROVIDER_CONFIG") + " c WHERE c.NAME = 'hideOnLoginPage'");
            try {
                resultSet = ps.executeQuery();
                try {
                    while (resultSet.next()) {
                        id = resultSet.getString(1);
                        value = resultSet.getString(2);
                        this.statements.add(new UpdateStatement(null, null, this.database.correctObjectName("IDENTITY_PROVIDER", Table.class)).addNewColumnValue("HIDE_ON_LOGIN", (Object)Boolean.parseBoolean(value)).setWhereClause("INTERNAL_ID=?").addWhereParameter((Object)id));
                    }
                    this.statements.add(new DeleteStatement(null, null, this.database.correctObjectName("IDENTITY_PROVIDER_CONFIG", Table.class)).setWhere("NAME=?").addWhereParameter((Object)"hideOnLoginPage"));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
        try {
            ps = this.connection.prepareStatement("SELECT c.IDENTITY_PROVIDER_ID, c.VALUE  FROM " + this.getTableName("IDENTITY_PROVIDER_CONFIG") + " c WHERE c.NAME = 'kc.org.broker.public'");
            try {
                resultSet = ps.executeQuery();
                try {
                    while (resultSet.next()) {
                        id = resultSet.getString(1);
                        value = resultSet.getString(2);
                        this.statements.add(new UpdateStatement(null, null, this.database.correctObjectName("IDENTITY_PROVIDER", Table.class)).addNewColumnValue("HIDE_ON_LOGIN", (Object)(!Boolean.parseBoolean(value) ? 1 : 0)).setWhereClause("INTERNAL_ID=?").addWhereParameter((Object)id));
                    }
                    this.statements.add(new DeleteStatement(null, null, this.database.correctObjectName("IDENTITY_PROVIDER_CONFIG", Table.class)).setWhere("NAME=?").addWhereParameter((Object)"kc.org.broker.public"));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Migrate kc.org and hideOnLoginPage from the IDP config to the IDP itself";
    }
}

