/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalkerFactory;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonLikePsiWalker {
    public ThreeState isName(PsiElement var1);

    public boolean isPropertyWithValue(@NotNull PsiElement var1);

    public PsiElement findElementToCheck(@NotNull PsiElement var1);

    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement var1, boolean var2);

    default public boolean hasObjectArrayAmbivalence() {
        return false;
    }

    public boolean requiresNameQuotes();

    default public boolean requiresValueQuotes() {
        return true;
    }

    public boolean allowsSingleQuotes();

    default public boolean isValidIdentifier(@NotNull String string, Project project) {
        if (string == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(0);
        }
        return true;
    }

    default public boolean isQuotedString(@NotNull PsiElement element) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(1);
        }
        return false;
    }

    default public String escapeInvalidIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(2);
        }
        return StringUtil.wrapWithDoubleQuote((String)identifier);
    }

    public boolean hasMissingCommaAfter(@NotNull PsiElement var1);

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement var1, PsiElement var2);

    default public int indentOf(@NotNull PsiElement element) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(3);
        }
        return 0;
    }

    default public int indentOf(@NotNull PsiFile file) {
        if (file == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(4);
        }
        return 4;
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement var1);

    public boolean isTopJsonElement(@NotNull PsiElement var1);

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement var1);

    default public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(5);
        }
        return element.getTextRange();
    }

    default public boolean acceptsEmptyRoot() {
        return false;
    }

    @Nullable
    public Collection<PsiElement> getRoots(@NotNull PsiFile var1);

    @Deprecated(forRemoval=true)
    @ApiStatus.Experimental
    default public boolean requiresReformatAfterArrayInsertion() {
        return true;
    }

    @Nullable
    public static JsonLikePsiWalker getWalker(@NotNull PsiElement element) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(6);
        }
        return JsonLikePsiWalker.getWalker(element, null);
    }

    @Nullable
    public static JsonLikePsiWalker getWalker(@NotNull PsiElement element, @Nullable JsonSchemaObject schemaObject) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(7);
        }
        if (JsonOriginalPsiWalker.INSTANCE.handles(element)) {
            return JsonOriginalPsiWalker.INSTANCE;
        }
        return JsonLikePsiWalkerFactory.EXTENSION_POINT_NAME.getExtensionList().stream().filter(extension -> extension.handles(element)).findFirst().map(extension -> extension.create(schemaObject)).orElse(null);
    }

    default public String getDefaultObjectValue() {
        return "{}";
    }

    default public String getDefaultArrayValue() {
        return "[]";
    }

    default public boolean hasWhitespaceDelimitedCodeBlocks() {
        return false;
    }

    default public String getNodeTextForValidation(PsiElement element) {
        return element.getText();
    }

    default public JsonLikeSyntaxAdapter getSyntaxAdapter(Project project) {
        return null;
    }

    @Nullable
    default public PsiElement getParentContainer(PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getPropertyNameElement(@Nullable PsiElement var1);

    default public String getPropertyValueSeparator(@Nullable JsonSchemaType valueType) {
        return ":";
    }

    default public boolean haveSameParentWithinObject(@NotNull PsiElement property1, @NotNull PsiElement property2) {
        if (property1 == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(8);
        }
        if (property2 == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(9);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property2";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonLikePsiWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidIdentifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isQuotedString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "escapeInvalidIdentifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "indentOf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustErrorHighlightingRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getWalker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "haveSameParentWithinObject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

