/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.util.TypedValue;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.arsc.ARSCHeader;
import brut.androlib.res.data.axml.NamespaceStack;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.decoder.StringBlock;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class AXmlResourceParser
implements XmlPullParser {
    public static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());
    public final ResTable mResTable;
    public final NamespaceStack mNamespaces;
    public boolean mIsOperational;
    public boolean mHasEncounteredStartElement;
    public ExtDataInputStream mIn;
    public StringBlock mStringBlock;
    public int[] mResourceIds;
    public boolean mDecreaseDepth;
    public AndrolibException mFirstError;
    public int mEvent;
    public int mLineNumber;
    public int mNameIndex;
    public int mNamespaceIndex;
    public int[] mAttributes;

    public final int getAttributeOffset(int n) {
        if (this.mEvent == 2) {
            int n2 = n * 5;
            if (n2 < this.mAttributes.length) {
                return n2;
            }
            throw new IndexOutOfBoundsException("Invalid attribute index (" + n + ").");
        }
        throw new IndexOutOfBoundsException("Current event is not START_TAG.");
    }

    public final void doNext() {
        block31: {
            ARSCHeader aRSCHeader;
            int n;
            long l;
            int n2;
            int n3;
            if (this.mStringBlock == null) {
                this.mIn.mDelegate.readInt();
                this.mIn.mDelegate.readInt();
                this.mStringBlock = StringBlock.readWithChunk(this.mIn);
                this.mNamespaces.increaseDepth();
                this.mIsOperational = true;
            }
            if ((n3 = this.mEvent) == 1) {
                return;
            }
            this.mEvent = -1;
            this.mLineNumber = -1;
            this.mNameIndex = -1;
            this.mNamespaceIndex = -1;
            this.mAttributes = null;
            while (true) {
                int n4;
                int n5;
                ARSCHeader aRSCHeader2;
                int n6;
                NamespaceStack namespaceStack;
                if (this.mDecreaseDepth) {
                    this.mDecreaseDepth = false;
                    namespaceStack = this.mNamespaces;
                    n6 = namespaceStack.mDataLength;
                    if (n6 != 0) {
                        int n7 = n6 - 1;
                        n7 = namespaceStack.mData[n7];
                        if (n6 - 2 - (n7 *= 2) != 0) {
                            namespaceStack.mDataLength = n6 - (n7 + 2);
                            --namespaceStack.mDepth;
                        }
                    }
                }
                if (n3 == 3) {
                    namespaceStack = this.mNamespaces;
                    if (namespaceStack.mDepth == 1) {
                        int n8;
                        n6 = namespaceStack.mDataLength;
                        if (n6 == 0) {
                            n8 = 0;
                        } else {
                            int n9 = n6 - 1;
                            n8 = namespaceStack.mData[n9];
                        }
                        if (n8 == 0) {
                            this.mEvent = 1;
                            break block31;
                        }
                    }
                }
                if (((InputStream)this.mIn).available() == 0) {
                    Long l2 = this.mIn.mCountIn.count;
                    LOGGER.warning(String.format("AXML hit unexpected end of file at byte: 0x%X", l2));
                    this.mEvent = 1;
                    break block31;
                }
                n2 = 0;
                ExtDataInputStream extDataInputStream = this.mIn;
                l = extDataInputStream.mCountIn.count;
                if (n3 == 0) {
                    n = 258;
                } else {
                    n = extDataInputStream.mDelegate.readUnsignedShort();
                    n2 = this.mIn.mDelegate.readUnsignedShort();
                }
                if (n == 384) {
                    n2 = this.mIn.mDelegate.readInt();
                    if (n2 >= 8 && n2 % 4 == 0) {
                        this.mResourceIds = this.mIn.readIntArray(n2 / 4 - 2);
                        continue;
                    }
                    throw new IOException("Invalid resource ids size (" + n2 + ").");
                }
                if (n < 256 || n > 383) break;
                if (n == 258 && n3 == -1) {
                    this.mEvent = 0;
                    break block31;
                }
                Object object = aRSCHeader2;
                aRSCHeader2 = new ARSCHeader((short)n, n2, this.mIn.mDelegate.readInt(), l);
                this.mLineNumber = this.mIn.mDelegate.readInt();
                this.mIn.mDelegate.readInt();
                if (n != 256 && n != 257) {
                    if (n == 258) {
                        this.mHasEncounteredStartElement = true;
                        this.mNamespaceIndex = this.mIn.mDelegate.readInt();
                        this.mNameIndex = this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readShort();
                        n3 = this.mIn.mDelegate.readUnsignedShort();
                        n2 = this.mIn.mDelegate.readUnsignedShort();
                        this.mIn.mDelegate.readUnsignedShort();
                        this.mIn.mDelegate.readUnsignedShort();
                        this.mIn.mDelegate.readUnsignedShort();
                        this.mAttributes = this.mIn.readIntArray(n2 * 5);
                        n = 3;
                        while (true) {
                            int[] nArray = this.mAttributes;
                            if (n >= this.mAttributes.length) break;
                            nArray[n] = nArray[n] >>> 24;
                            n += 5;
                        }
                        n = n2 * 20;
                        if (n < (n3 *= n2)) {
                            this.mIn.skipBytes(n3 -= n);
                            LOGGER.fine("Skipping " + n3 + " unknown bytes in attributes area.");
                        }
                        this.mNamespaces.increaseDepth();
                        this.mEvent = 2;
                    } else if (n == 259) {
                        this.mNamespaceIndex = this.mIn.mDelegate.readInt();
                        this.mNameIndex = this.mIn.mDelegate.readInt();
                        this.mEvent = 3;
                        this.mDecreaseDepth = true;
                    } else {
                        if (n != 260) continue;
                        this.mNameIndex = this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        this.mEvent = 4;
                    }
                    break block31;
                }
                if (n == 256) {
                    n = this.mIn.mDelegate.readInt();
                    n5 = this.mIn.mDelegate.readInt();
                    NamespaceStack namespaceStack2 = this.mNamespaces;
                    if (namespaceStack2.mDepth == 0) {
                        namespaceStack2.increaseDepth();
                    }
                    object = namespaceStack2.mData;
                    int n10 = namespaceStack2.mDataLength;
                    int n11 = namespaceStack2.mData.length - n10;
                    if (n11 <= 2) {
                        Object object2 = object;
                        object = new int[(((Object)object2).length + n11) * 2];
                        System.arraycopy(object2, 0, object, 0, n10);
                        namespaceStack2.mData = (int[])object;
                    }
                    int n12 = namespaceStack2.mDataLength;
                    n4 = n12 - 1;
                    int[] nArray = namespaceStack2.mData;
                    int n13 = n;
                    n = nArray[n4];
                    nArray[n12 - 2 - n * 2] = ++n;
                    nArray[n4] = n13;
                    nArray[n12] = n5;
                    namespaceStack2.mData[n12 - -1] = n;
                    namespaceStack2.mDataLength = n12 + 2;
                } else {
                    if (!this.mHasEncounteredStartElement) {
                        Long l3 = ((ARSCHeader)object).endPosition;
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = l3;
                        LOGGER.warning(String.format("Skipping end namespace event at %d, element has not been encountered.", objectArray2));
                        this.mIn.jumpTo(((ARSCHeader)object).endPosition);
                        break block31;
                    }
                    this.mIn.mDelegate.readInt();
                    this.mIn.mDelegate.readInt();
                    NamespaceStack namespaceStack3 = this.mNamespaces;
                    n5 = namespaceStack3.mDataLength;
                    if (n5 != 0) {
                        n4 = n5 - 1;
                        object = namespaceStack3.mData;
                        if ((n4 = namespaceStack3.mData[n4]) != 0) {
                            int n14 = n5;
                            int n15 = n4 + -1;
                            object[n5 -= 3] = n15;
                            object[n5 - (n15 * 2 + 1)] = n15;
                            namespaceStack3.mDataLength = n14 - 2;
                        }
                    }
                }
                if (n2 <= 16) continue;
                Integer n16 = n2 -= 16;
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = n16;
                LOGGER.warning(String.format("AXML START/END namespace header larger than 0x10 bytes, skipping %d bytes.", objectArray3));
                this.mIn.skipBytes(n2);
            }
            ARSCHeader aRSCHeader3 = aRSCHeader;
            short s = (short)n;
            n = s;
            aRSCHeader = new ARSCHeader(s, n2, this.mIn.mDelegate.readInt(), l);
            this.mIn.jumpTo(aRSCHeader3.endPosition);
            StringBuilder stringBuilder = new StringBuilder("Chunk type ");
            stringBuilder.append(n);
            stringBuilder.append(" is not supported, skipping...");
            LOGGER.warning(stringBuilder.toString());
        }
    }

    public final String getName() {
        int n;
        int n2 = this.mNameIndex;
        if (n2 != -1 && ((n = this.mEvent) == 2 || n == 3)) {
            return this.mStringBlock.getString(n2);
        }
        return null;
    }

    public final String getText() {
        int n = this.mNameIndex;
        if (n != -1 && this.mEvent == 4) {
            return this.mStringBlock.getString(n);
        }
        return null;
    }

    public final int getNamespaceCount(int n) {
        int n2;
        NamespaceStack namespaceStack = ((AXmlResourceParser)((Object)namespaceStack)).mNamespaces;
        if (namespaceStack.mDataLength != 0 && n >= 0) {
            n2 = namespaceStack.mDepth;
            if (n > n2) {
                n = n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n != 0) {
                int n4 = namespaceStack.mData[n3];
                n2 += n4;
                n3 = n4 * 2 + 2 + n3;
                --n;
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    public final String getAttributeNamespace(int n) {
        ResID resID;
        AXmlResourceParser aXmlResourceParser = this;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        int n3 = aXmlResourceParser.mAttributes[n2];
        ResID resID2 = resID;
        resID = new ResID(this.getAttributeNameResource(n));
        if (n3 == -1 && (resID2.mId >> 24 & 0xFF) == 1) {
            return "http://schemas.android.com/apk/res/android";
        }
        if (n3 == -1) {
            return "";
        }
        String string = this.mStringBlock.getString(n3);
        if (string != null && !string.isEmpty()) {
            return string;
        }
        if ((resID2.mId >> 24 & 0xFF) == 127) {
            return this.mStringBlock.getString(this.mNamespaces.get(n2, true)) == null ? "http://schemas.android.com/apk/res-auto" : this.mStringBlock.getString(this.mNamespaces.get(n2, false));
        }
        return "http://schemas.android.com/apk/res/android";
    }

    public final String decodeFromResourceId(int n) {
        if (n != 0) {
            try {
                return StringUtils.replace(this.mResTable.getResSpec((int)n).mName, "\"", "q");
            }
            catch (CantFindFrameworkResException cantFindFrameworkResException) {
            }
            catch (UndefinedResObjectException undefinedResObjectException) {}
        }
        return null;
    }

    public final String getAttributeName(int n) {
        String string;
        AXmlResourceParser aXmlResourceParser = string2;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        if ((n2 = aXmlResourceParser.mAttributes[n2 + 1]) == -1) {
            return "";
        }
        AXmlResourceParser aXmlResourceParser2 = string2;
        String string2 = ((AXmlResourceParser)((Object)string2)).mStringBlock.getString(n2);
        n = aXmlResourceParser2.getAttributeNameResource(n);
        try {
            string = aXmlResourceParser2.decodeFromResourceId(n);
        }
        catch (AndrolibException androlibException) {
            string = null;
        }
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        return "APKTOOL_MISSING_" + Integer.toHexString(n);
    }

    public final int getAttributeNameResource(int n) {
        AXmlResourceParser aXmlResourceParser = this;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        n2 = aXmlResourceParser.mAttributes[n2 + 1];
        int[] nArray = aXmlResourceParser.mResourceIds;
        if (aXmlResourceParser.mResourceIds != null && n2 >= 0 && n2 < nArray.length) {
            return nArray[n2];
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAttributeValue(int var1_1) {
        block28: {
            block30: {
                block29: {
                    v0 = this;
                    var2_3 = v0.getAttributeOffset(var1_1);
                    var3_4 = v0.mAttributes;
                    v1 = var2_3;
                    v2 = var2_3;
                    var2_3 = var3_4[var2_3 + 3];
                    var3_5 = var3_4[v2 + 4];
                    var4_6 = v0.mAttributes[v1 + 2];
                    if (var4_6 == -1) ** GOTO lbl13
                    try {
                        block31: {
                            var4_7 = ResXmlEncoders.escapeXmlChars(this.mStringBlock.getString(var4_6));
                            break block31;
lbl13:
                            // 1 sources

                            var4_7 = null;
                        }
                        var5_9 = null;
                        if (var2_3 == 1 || var2_3 == 7 || var2_3 == 2 || var2_3 == 8) {
                            var5_9 = this.decodeFromResourceId(var3_5);
                        }
                        if (var4_7 != null && var5_9 != null) {
                            var6_13 = var4_7.lastIndexOf("/");
                        }
                        ** GOTO lbl32
                    }
                    catch (AndrolibException var4_8) {
                        break block28;
                    }
                    var7_16 = var4_7.lastIndexOf(":");
                    if (var6_13 == -1) ** GOTO lbl30
                    if (var7_16 != -1) ** GOTO lbl32
                    var4_7 = var4_7.substring(0, var6_13);
                    {
                        block32: {
                            var4_7 = (String)var4_7 + "/" + var5_9;
                            break block32;
lbl30:
                            // 1 sources

                            if (!var4_7.equals(var5_9)) {
                                var4_7 = var5_9;
                            }
                        }
                        v3 = this;
                        var5_10 = v3.getAttributeNameResource(var1_1);
                        var6_14 = v3.mResTable;
                    }
                    {
                        var7_17 = var6_14.mMainPackage;
                        if (var7_17 != null) break block29;
                    }
                    var7_17 = var6_14.getPackage(1);
                }
                var4_7 = var7_17.getValueFactory().factory((String)var4_7, var2_3, var3_5);
                var6_14 = null;
                if (var5_10 <= 0) break block30;
                {
                    var5_11 = this.mResTable.getResSpec(var5_10);
                }
                var7_17 = v4;
                {
                    v4 = new ResConfigFlags();
                    var8_19 = (ResResource)var5_11.mResources.get(var7_17);
                    if (var8_19 == null) ** GOTO lbl-1000
                }
                {
                    var6_14 = ((ResAttr)var8_19.mValue).convertToResXmlFormat((ResScalarValue)var4_7);
                    break block30;
                }
lbl-1000:
                // 1 sources

                {
                    v5 = v6;
                    v7 = v6;
                }
                var8_19 = v8;
                {
                    v9 = var7_17;
                    v10 = var8_19;
                    v11 = v10;
                    var8_19("resource: spec=");
                    v10.append(var5_11);
                }
                {
                    v11.append(", config=");
                }
                {
                    v8.append(v9);
                }
                {
                    v5(v8.toString());
                    throw v7;
                }
            }
            if (var6_14 == null) return var4_7.encodeAsResXmlAttr();
            return var6_14;
        }
        if (this.mFirstError == null) {
            this.mFirstError = var4_8;
        }
        v12 = this;
        var5_12 = AXmlResourceParser.LOGGER;
        var6_15 = Level.WARNING;
        var7_18 = "Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x";
        var8_20 = v12.getAttributeOffset(var1_1);
        var8_20 = v12.mAttributes[var8_20];
        var9_22 = v12.mNamespaces;
        var10_23 = var9_22.mDataLength;
        if (var10_23 == 0) {
            while (true) {
                var8_20 = -1;
                break;
            }
        } else {
            --var10_23;
            var11_24 = var9_22.mDepth;
            block19: while (true) {
                if (var11_24 == 0) ** continue;
                var12_25 = var9_22.mData[var10_23];
                var10_23 -= 2;
                while (var12_25 != 0) {
                    var13_26 = var9_22.mData;
                    if (var9_22.mData[var10_23 + 1] == var8_20) {
                        var8_20 = var13_26[var10_23];
                        break block19;
                    }
                    var10_23 -= 2;
                    --var12_25;
                }
                --var11_24;
            }
        }
        var8_21 = var8_20 == -1 ? "" : this.mStringBlock.getString(var8_20);
        this = this.getAttributeName(var1_1);
        var1_2 = var3_5;
        var5_12.log(var6_15, String.format(var7_18, new Object[]{var8_21, this, var1_2}), var4_8);
        return TypedValue.coerceToString(var2_3, var3_5);
    }

    public AXmlResourceParser(ResTable resTable) {
        NamespaceStack namespaceStack;
        ((AXmlResourceParser)((Object)namespaceStack2)).mResTable = resTable;
        NamespaceStack namespaceStack2 = namespaceStack;
        namespaceStack = new NamespaceStack();
        v1.mNamespaces = namespaceStack2;
        v1.mEvent = -1;
        v1.mLineNumber = -1;
        v1.mNameIndex = -1;
        v1.mNamespaceIndex = -1;
        v1.mAttributes = null;
    }
}

