/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.providers;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.management.MBeanServer;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.DumpProvider;

public class HeapDumpProvider
implements DumpProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDump(DumpDestination destination) throws Exception {
        File heapDumpFile = null;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int l;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Class<?> diagnosticMXBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Object diagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServer, "com.sun.management:type=HotSpotDiagnostic", diagnosticMXBeanClass);
            heapDumpFile = Files.createTempFile("heapdump", ".hprof", new FileAttribute[0]).toFile();
            heapDumpFile.delete();
            Method method = diagnosticMXBeanClass.getMethod("dumpHeap", String.class, Boolean.TYPE);
            method.invoke(diagnosticMXBean, heapDumpFile.getAbsolutePath(), false);
            in = new FileInputStream(heapDumpFile);
            out = destination.add("heapdump.hprof");
            byte[] buffer = new byte[2048];
            while ((l = in.read(buffer)) != -1) {
                out.write(buffer, 0, l);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            if (heapDumpFile != null && heapDumpFile.exists()) {
                heapDumpFile.delete();
            }
        }
    }
}

