/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;

public class Category {
    private String name;
    private List<IssueImpl> tasks;
    private boolean loaded;

    public Category(String name, List<IssueImpl> tasks) {
        this(name, tasks, true);
    }

    public Category(String name) {
        this(name, new ArrayList<IssueImpl>(), false);
    }

    public Category(String name, List<IssueImpl> tasks, boolean loaded) {
        this.name = name;
        this.tasks = tasks;
        this.loaded = loaded;
    }

    public void removeTask(IssueImpl task) {
        this.tasks.remove(task);
    }

    public void addTask(IssueImpl task) {
        this.tasks.add(task);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<IssueImpl> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<IssueImpl> tasks) {
        if (!this.loaded && tasks != null) {
            this.loaded = true;
        }
        this.tasks = tasks;
    }

    public boolean persist() {
        return true;
    }

    public void reload() {
        this.loaded = false;
        this.refresh();
    }

    public int sortIndex() {
        return 100;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        return this.name.equalsIgnoreCase(other.name);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public void refresh() {
        if (this.loaded) {
            this.refreshTasks();
        } else {
            DashboardUtils.loadCategory(this);
        }
    }

    protected void refreshTasks() {
        Map<RepositoryImpl, List<String>> map = this.getTasksToRepository(this.getTasks());
        Set<RepositoryImpl> repositoryKeys = map.keySet();
        for (RepositoryImpl repository : repositoryKeys) {
            List<String> ids = map.get(repository);
            repository.getIssueImpls(ids.toArray(new String[0]));
        }
    }

    private Map<RepositoryImpl, List<String>> getTasksToRepository(List<IssueImpl> tasks) {
        HashMap<RepositoryImpl, List<String>> map = new HashMap<RepositoryImpl, List<String>>();
        for (IssueImpl issue : tasks) {
            RepositoryImpl repositoryKey = issue.getRepositoryImpl();
            if (map.containsKey(repositoryKey)) {
                ((List)map.get(repositoryKey)).add(issue.getID());
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(issue.getID());
            map.put(repositoryKey, list);
        }
        return map;
    }
}

