/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;

public class LinkButton
extends JButton {
    public LinkButton(LinkCookie panel, Object ddBean, String ddProperty) {
        LinkButton.initLinkButton(this, panel, ddBean, ddProperty);
    }

    public static void initLinkButton(final AbstractButton button, LinkCookie panel, Object ddBean, String ddProperty) {
        button.setForeground(SectionVisualTheme.hyperlinkColor);
        button.setHorizontalAlignment(2);
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        String text = LinkButton.getFormatedLinkText(button.getText());
        button.setAction(new LinkAction(panel, ddBean, ddProperty));
        button.setText(text);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setCursor(Cursor.getPredefinedCursor(12));
                button.setForeground(SectionVisualTheme.hyperlinkColorFocused);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setCursor(Cursor.getDefaultCursor());
                button.setForeground(SectionVisualTheme.hyperlinkColor);
            }
        });
    }

    @Override
    public void setText(String text) {
        super.setText(LinkButton.getFormatedLinkText(text));
    }

    private static String getFormatedLinkText(String text) {
        return "<html><b><u>" + LinkButton.getColorizedText(text) + "</u></b></html>";
    }

    private static String getColorizedText(String text) {
        Color linkColor = UIManager.getColor("nb.html.link.foreground");
        if (linkColor == null) {
            return text;
        }
        return "<font color=\"#" + Integer.toHexString(linkColor.getRGB()).substring(2) + "\">" + text + "</font>";
    }

    public static class LinkAction
    extends AbstractAction {
        LinkCookie panel;
        Object ddBean;
        String ddProperty;

        public LinkAction(LinkCookie panel, Object ddBean, String ddProperty) {
            this.panel = panel;
            this.ddBean = ddBean;
            this.ddProperty = ddProperty;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.panel.linkButtonPressed(this.ddBean, this.ddProperty);
        }
    }
}

