/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.jstl.core;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;

public final class IndexedValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    protected final Integer i;
    protected final ValueExpression orig;

    public IndexedValueExpression(ValueExpression orig, int i) {
        this.i = i;
        this.orig = orig;
    }

    @Override
    public Object getValue(ELContext context) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(false);
            return context.getELResolver().getValue(context, base, this.i);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object value) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(false);
            context.getELResolver().setValue(context, base, this.i, value);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(false);
            return context.getELResolver().isReadOnly(context, base, this.i);
        }
        return true;
    }

    public Class getType(ELContext context) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(false);
            return context.getELResolver().getType(context, base, this.i);
        }
        return null;
    }

    public Class getExpectedType() {
        return Object.class;
    }

    @Override
    public String getExpressionString() {
        return this.orig.getExpressionString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.orig.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.orig.hashCode();
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }
}

