/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.devops;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DevopsProjectService {
    private static DevopsConfigFinder finder = null;

    public static List<String> getDevopsProjectOcid() {
        List<FileObject> configs = DevopsProjectService.getDefaultFinder().findDevopsConfig();
        Gson gson = new Gson();
        ArrayList<String> devopsOcid = new ArrayList<String>();
        try {
            for (FileObject config : configs) {
                JsonObject json = (JsonObject)gson.fromJson((Reader)new InputStreamReader(configs.get(0).getInputStream()), JsonObject.class);
                JsonArray services = json.getAsJsonArray("cloudServices");
                for (JsonElement service : services) {
                    JsonElement type = service.getAsJsonObject().get("type");
                    if (type == null || !"oci".equals(type.getAsString())) continue;
                    JsonObject data = service.getAsJsonObject().getAsJsonObject("data");
                    JsonObject context = data.getAsJsonObject("context");
                    devopsOcid.add(context.get("devopsProject").getAsString());
                }
            }
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return devopsOcid;
    }

    private static DevopsConfigFinder getDefaultFinder() {
        if (finder == null) {
            finder = (DevopsConfigFinder)Lookup.getDefault().lookup(DevopsConfigFinder.class);
        }
        if (finder == null) {
            finder = new DefaultDevopsConfigFinder();
        }
        return finder;
    }

    public static interface DevopsConfigFinder {
        public List<FileObject> findDevopsConfig();
    }

    static class DefaultDevopsConfigFinder
    implements DevopsConfigFinder {
        DefaultDevopsConfigFinder() {
        }

        @Override
        public List<FileObject> findDevopsConfig() {
            return Collections.emptyList();
        }
    }
}

