/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.problems;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NpmExecutable;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.problems.Bundle;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.StringUtils;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.WeakListeners;

public final class NpmProblemsProvider
implements ProjectProblemsProvider {
    final FileChangeListener fileChangeListener = new FileChangeListener();
    final Project project;
    private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private final PackageJson packageJson;

    private NpmProblemsProvider(Project project) {
        this.project = project;
        this.packageJson = new PackageJson(project.getProjectDirectory());
    }

    private static NpmProblemsProvider create(Project project) {
        NpmProblemsProvider npmProblemsProvider = new NpmProblemsProvider(project);
        FileObject projectDirectory = project.getProjectDirectory();
        projectDirectory.addFileChangeListener((org.openide.filesystems.FileChangeListener)WeakListeners.create(org.openide.filesystems.FileChangeListener.class, (EventListener)((Object)npmProblemsProvider.fileChangeListener), (Object)projectDirectory));
        return npmProblemsProvider;
    }

    public static ProjectProblemsProvider forHtml5Project(Project project) {
        return NpmProblemsProvider.create(project);
    }

    public static ProjectProblemsProvider forPhpProject(Project project) {
        return NpmProblemsProvider.create(project);
    }

    public static ProjectProblemsProvider forWebProject(Project project) {
        return NpmProblemsProvider.create(project);
    }

    public static ProjectProblemsProvider forMavenProject(Project project) {
        return NpmProblemsProvider.create(project);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                NpmProblemsProvider.this.checkDependencies(currentProblems);
                return currentProblems;
            }
        });
    }

    void checkDependencies(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        if (this.npmInstallRequired()) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.NpmProblemsProvider_dependencies_none_title(), (String)Bundle.NpmProblemsProvider_dependencies_none_description(NodeJsUtils.getProjectDisplayName(this.project)), (ProjectProblemResolver)new ProjectProblemResolverImpl("npmInstall", new NpmInstallResult()));
            currentProblems.add(problem);
        }
    }

    boolean npmInstallRequired() {
        if (!this.packageJson.exists()) {
            return false;
        }
        if (this.packageJson.getNodeModulesDir().isDirectory()) {
            return false;
        }
        return !this.packageJson.getDependencies().isEmpty();
    }

    void fireProblemsChanged() {
        this.problemsProviderSupport.fireProblemsChange();
    }

    private final class FileChangeListener
    extends FileChangeAdapter {
        private FileChangeListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            this.processFileChange(fe.getFile().getNameExt());
        }

        public void fileChanged(FileEvent fe) {
            this.processFileChange(fe.getFile().getNameExt());
        }

        public void fileFolderCreated(FileEvent fe) {
            this.processFolderChange(fe.getFile().getNameExt());
        }

        public void fileDeleted(FileEvent fe) {
            this.processFolderChange(fe.getFile().getNameExt());
        }

        public void fileRenamed(FileRenameEvent fe) {
            String oldName = fe.getName() + (StringUtils.hasText(fe.getExt()) ? "." + fe.getExt() : "");
            this.processFileChange(fe.getFile().getNameExt());
            this.processFileChange(oldName);
            this.processFolderChange(fe.getFile().getNameExt());
            this.processFolderChange(oldName);
        }

        private void processFileChange(String fileName) {
            if ("package.json".equals(fileName)) {
                NpmProblemsProvider.this.fireProblemsChanged();
            }
        }

        private void processFolderChange(String folderName) {
            if ("node_modules".equals(folderName)) {
                NpmProblemsProvider.this.fireProblemsChanged();
            }
        }
    }

    private static final class ProjectProblemResolverImpl
    implements ProjectProblemResolver {
        private final String ident;
        private final Future<ProjectProblemsProvider.Result> resolver;

        public ProjectProblemResolverImpl(String ident, Future<ProjectProblemsProvider.Result> resolver) {
            assert (ident != null);
            assert (resolver != null);
            this.ident = ident;
            this.resolver = resolver;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            return this.resolver;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.ident);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectProblemResolverImpl other = (ProjectProblemResolverImpl)obj;
            return Objects.equals(this.ident, other.ident);
        }
    }

    private final class NpmInstallResult
    implements Future<ProjectProblemsProvider.Result> {
        private Future<Integer> task;

        private NpmInstallResult() {
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            if (this.task == null) {
                return false;
            }
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public synchronized boolean isCancelled() {
            if (this.task == null) {
                return false;
            }
            return this.task.isCancelled();
        }

        @Override
        public synchronized boolean isDone() {
            if (this.task == null) {
                return false;
            }
            return this.task.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProjectProblemsProvider.Result get() throws InterruptedException, ExecutionException {
            try {
                this.getTask().get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (NpmProblemsProvider.this.npmInstallRequired()) {
                NpmInstallResult npmInstallResult = this;
                synchronized (npmInstallResult) {
                    this.task = null;
                }
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
            }
            NpmProblemsProvider.this.fireProblemsChanged();
            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
        }

        @Override
        public ProjectProblemsProvider.Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        public synchronized Future<Integer> getTask() {
            if (this.task == null) {
                NpmExecutable npm = NpmExecutable.getDefault(NpmProblemsProvider.this.project, true);
                if (npm != null) {
                    NodeJsUtils.logUsageNpmInstall();
                    this.task = npm.install(new String[0]);
                } else {
                    this.task = new DummyTask();
                }
            }
            return this.task;
        }
    }

    private static final class DummyTask
    implements Future<Integer> {
        private DummyTask() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            return -1;
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

