/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import javax.lang.model.SourceVersion;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class BoxedIdentityComparison {
    private static final String JU_OBJECTS = "java.util.Objects";

    public static ErrorDescription wrapperComparisonUsingIdentity(HintContext ctx) {
        TreePath logExprPath = ctx.getPath();
        BinaryTree bt = (BinaryTree)logExprPath.getLeaf();
        TreePath wrapperPath = (TreePath)ctx.getVariables().get("$x");
        ExpressionTree otherOperand = bt.getRightOperand();
        TypeMirror t = ctx.getInfo().getTrees().getTypeMirror(new TreePath(logExprPath, otherOperand));
        if (t == null || t.getKind() != TypeKind.DECLARED) {
            return null;
        }
        t = ctx.getInfo().getTrees().getTypeMirror(wrapperPath);
        if (t == null || t.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Fix fix = ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0 ? null : new NullSafeEqualsFix(TreePathHandle.create((TreePath)logExprPath, (CompilationInfo)ctx.getInfo())).toEditorFix();
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)logExprPath, (String)Bundle.TEXT_BoxedValueIdentityComparison(ctx.getInfo().getTypeUtilities().getTypeName(t, new TypeUtilities.TypeNameOptions[0])), (Fix[])new Fix[]{fix});
    }

    private static class NullSafeEqualsFix
    extends JavaFix {
        public NullSafeEqualsFix(TreePathHandle handle) {
            super(handle);
        }

        protected String getText() {
            return Bundle.FIX_UseNullSafeEquals();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath p = ctx.getPath();
            if (p.getLeaf().getKind() != Tree.Kind.EQUAL_TO && p.getLeaf().getKind() != Tree.Kind.NOT_EQUAL_TO) {
                return;
            }
            BinaryTree bt = (BinaryTree)p.getLeaf();
            TreeMaker mk = ctx.getWorkingCopy().getTreeMaker();
            ExpressionTree replace = mk.MethodInvocation(Collections.emptyList(), (ExpressionTree)mk.MemberSelect(mk.QualIdent(BoxedIdentityComparison.JU_OBJECTS), (CharSequence)"equals"), Arrays.asList(bt.getLeftOperand(), bt.getRightOperand()));
            if (bt.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                replace = mk.Unary(Tree.Kind.LOGICAL_COMPLEMENT, replace);
            }
            ctx.getWorkingCopy().rewrite((Tree)bt, (Tree)replace);
        }
    }
}

