/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.parser.EntriesCache;
import org.netbeans.modules.subversion.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.netbeans.modules.subversion.config.KVFile;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;

public class WorkingCopyDetails {
    static final String FILE_ATTRIBUTE_VALUE = "file";
    static final String IS_HANDLED = "handled";
    private static final char SLASH_N = '\n';
    private static final char SLASH_R = '\r';
    static final String VERSION_ATTR_KEY = "wc-version";
    static final String VERSION_UNKNOWN = "";
    static final String VERSION_13 = "1.3";
    static final String VERSION_14 = "1.4";
    static final String ATTR_TREE_CONFLICT_DESCRIPTOR = "is-in-conflict";
    private final File file;
    private final Map<String, String> attributes;
    private Map<String, byte[]> workingSvnProperties = null;
    private Map<String, byte[]> baseSvnProperties = null;
    protected File propertiesFile = null;
    private File basePropertiesFile = null;
    private File textBaseFile = null;
    private final SVNConflictDescriptor conflictDescriptor;

    private WorkingCopyDetails(File file, Map<String, String> attributes, SVNConflictDescriptor conflictDescriptor) {
        this.file = file;
        this.attributes = attributes;
        this.conflictDescriptor = conflictDescriptor;
    }

    public static WorkingCopyDetails createWorkingCopy(File file, Map<String, String> attributes) {
        String version;
        SVNConflictDescriptor conflictDescriptor = null;
        if (attributes != null) {
            conflictDescriptor = EntriesCache.getInstance().getConflictDescriptor(file.getName(), attributes.get(ATTR_TREE_CONFLICT_DESCRIPTOR));
        }
        String string = version = attributes != null ? attributes.get(VERSION_ATTR_KEY) : VERSION_UNKNOWN;
        if (version != null) {
            if (version.equals(VERSION_13)) {
                return new WorkingCopyDetails(file, attributes, conflictDescriptor);
            }
            if (version.equals(VERSION_14)) {
                return new WorkingCopyDetails(file, (Map)attributes, conflictDescriptor){

                    @Override
                    public boolean propertiesExist() throws IOException {
                        return this.getAttributes().containsKey("has-props");
                    }

                    @Override
                    public boolean propertiesModified() throws IOException {
                        return this.getAttributes().containsKey("has-prop-mods");
                    }

                    @Override
                    File getPropertiesFile() throws IOException {
                        if (this.propertiesFile == null) {
                            boolean modified = this.getBooleanValue("has-prop-mods");
                            this.propertiesFile = SvnWcUtils.getPropertiesFile(this.getFile(), !modified);
                        }
                        return this.propertiesFile;
                    }
                };
            }
            if (version.equals(VERSION_UNKNOWN)) {
                WorkingCopyDetails wcd = new WorkingCopyDetails(file, attributes, conflictDescriptor);
                if (!wcd.isHandled()) {
                    return wcd;
                }
                throw new UnsupportedOperationException("Unknown SVN working copy version: " + version);
            }
            throw new UnsupportedOperationException("Unknown SVN working copy version: " + version);
        }
        Subversion.LOG.warning("Could not determine the SVN working copy version for " + file + ". Falling back on 1.3");
        return new WorkingCopyDetails(file, attributes, conflictDescriptor);
    }

    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    protected File getFile() {
        return this.file;
    }

    public String getValue(String propertyName, String defaultValue) {
        String returnValue = this.getValue(propertyName);
        return returnValue != null ? returnValue : defaultValue;
    }

    public String getValue(String key) {
        if (key == null) {
            return null;
        }
        return this.getAttributes() != null ? this.getAttributes().get(key) : null;
    }

    public long getLongValue(String key) throws LocalSubversionException {
        try {
            String value = this.getValue(key);
            if (value == null) {
                return -1L;
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new LocalSubversionException(ex);
        }
    }

    public Date getDateValue(String key) throws LocalSubversionException {
        try {
            String value = this.getValue(key);
            if (value == null || value.equals(VERSION_UNKNOWN)) {
                return null;
            }
            return SvnWcUtils.parseSvnDate(value);
        }
        catch (ParseException ex) {
            throw new LocalSubversionException(ex);
        }
    }

    public boolean getBooleanValue(String key) {
        String value = this.getValue(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean isHandled() {
        return this.getBooleanValue(IS_HANDLED);
    }

    public boolean isFile() {
        return this.getAttributes() != null ? FILE_ATTRIBUTE_VALUE.equals(this.getAttributes().get("kind")) : false;
    }

    File getPropertiesFile() throws IOException {
        if (this.propertiesFile == null) {
            this.propertiesFile = SvnWcUtils.getPropertiesFile(this.file, false);
        }
        return this.propertiesFile;
    }

    File getBasePropertiesFile() throws IOException {
        if (this.basePropertiesFile == null) {
            this.basePropertiesFile = SvnWcUtils.getPropertiesFile(this.file, true);
        }
        return this.basePropertiesFile;
    }

    private File getTextBaseFile() throws IOException {
        if (this.textBaseFile == null) {
            this.textBaseFile = SvnWcUtils.getTextBaseFile(this.file);
        }
        return this.textBaseFile;
    }

    private Map<String, byte[]> getWorkingSvnProperties() throws IOException {
        if (this.workingSvnProperties == null) {
            this.workingSvnProperties = this.loadProperties(this.getPropertiesFile());
        }
        return this.workingSvnProperties;
    }

    private Map<String, byte[]> getBaseSvnProperties() throws IOException {
        if (this.baseSvnProperties == null) {
            this.baseSvnProperties = this.loadProperties(this.getBasePropertiesFile());
        }
        return this.baseSvnProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean propertiesExist() throws IOException {
        boolean returnValue = false;
        File propsFile = this.getPropertiesFile();
        boolean bl = returnValue = propsFile != null ? propsFile.exists() : false;
        if (returnValue) {
            try (FileInputStream inputStream = new FileInputStream(propsFile);){
                int size;
                int retval = ((InputStream)inputStream).read();
                for (size = 0; retval != -1 && size < 5; ++size) {
                    retval = ((InputStream)inputStream).read();
                }
                returnValue = size > 4;
            }
        }
        return returnValue;
    }

    public boolean propertiesModified() throws IOException {
        Map<String, byte[]> baseProps = this.getBaseSvnProperties();
        Map<String, byte[]> props = this.getWorkingSvnProperties();
        if (baseProps == null && props != null) {
            return true;
        }
        if (baseProps != null && props == null) {
            return true;
        }
        if (baseProps == null && props == null) {
            return false;
        }
        if (baseProps.size() != props.size()) {
            return true;
        }
        for (Map.Entry<String, byte[]> baseEntry : baseProps.entrySet()) {
            byte[] propsValue = props.get(baseEntry.getKey());
            if (propsValue != null && Arrays.equals(propsValue, baseEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    private Map<String, byte[]> loadProperties(File propsFile) throws IOException {
        if (propsFile == null || !propsFile.exists()) {
            return null;
        }
        KVFile kv = new KVFile(propsFile);
        return kv.getNormalizedMap();
    }

    public boolean textModified() throws IOException {
        if (this.file.exists()) {
            File baseFile = this.getTextBaseFile();
            if (this.file == null && baseFile != null) {
                return true;
            }
            if (this.file != null && baseFile == null) {
                return true;
            }
            if (this.file == null && baseFile == null) {
                return false;
            }
            Map<String, byte[]> workingSvnProps = this.getWorkingSvnProperties();
            if (workingSvnProps != null) {
                String svnSpecial = this.getPropertyValue(workingSvnProps, "svn:special");
                if (svnSpecial != null && svnSpecial.equals("*") && this.isSymbolicLink()) {
                    return false;
                }
                String svnKeywords = this.getPropertyValue(workingSvnProps, "svn:keywords");
                if (svnKeywords != null) {
                    return this.isModifiedByLine(svnKeywords.trim());
                }
            }
            return this.isModifiedByByte();
        }
        return false;
    }

    SVNConflictDescriptor getConflictDescriptor() {
        return this.conflictDescriptor;
    }

    private String getPropertyValue(Map<String, byte[]> props, String key) {
        byte[] byteValue = props.get(key);
        if (byteValue != null && byteValue.length > 0) {
            return new String(byteValue);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSymbolicLink() throws IOException {
        boolean returnValue = false;
        File baseFile = this.getTextBaseFile();
        if (baseFile != null) {
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new FileReader(baseFile));
                String firstLine = reader.readLine();
                returnValue = firstLine.startsWith("link");
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModifiedByByte() throws IOException {
        boolean returnValue = false;
        InputStream baseStream = null;
        InputStream fileStream = null;
        try {
            baseStream = new BufferedInputStream(new FileInputStream(this.textBaseFile));
            fileStream = new BufferedInputStream(new FileInputStream(this.file));
            int baseRetVal = baseStream.read();
            int fileRetVal = fileStream.read();
            while (baseRetVal != -1) {
                if (baseRetVal != fileRetVal) {
                    boolean isLineEnding = false;
                    if ('\n' == (char)baseRetVal && '\r' == (char)fileRetVal) {
                        fileRetVal = fileStream.read();
                        isLineEnding = '\n' == (char)fileRetVal;
                    } else if ('\n' == (char)fileRetVal && '\r' == (char)baseRetVal) {
                        baseRetVal = baseStream.read();
                        boolean bl = isLineEnding = '\n' == (char)baseRetVal;
                    }
                    if (!isLineEnding) {
                        boolean bl = true;
                        return bl;
                    }
                }
                baseRetVal = baseStream.read();
                fileRetVal = fileStream.read();
            }
            returnValue = fileRetVal != -1;
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
            if (baseStream != null) {
                baseStream.close();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModifiedByLine(String rawKeywords) throws IOException {
        if (rawKeywords == null || rawKeywords.equals(VERSION_UNKNOWN)) {
            return false;
        }
        boolean returnValue = false;
        ArrayList<String> keywordsList = new ArrayList<String>();
        rawKeywords = rawKeywords.replace("\n", " ");
        rawKeywords = rawKeywords.replace("\t", " ");
        keywordsList.addAll(this.normalizeKeywords(rawKeywords.split(" ")));
        String[] keywords = keywordsList.toArray(new String[0]);
        BufferedReader baseReader = null;
        BufferedReader fileReader = null;
        try {
            baseReader = new BufferedReader(new FileReader(this.textBaseFile));
            fileReader = new BufferedReader(new FileReader(this.file));
            String baseLine = baseReader.readLine();
            String fileLine = fileReader.readLine();
            while (baseLine != null && fileLine != null) {
                if (!fileLine.equals(baseLine)) {
                    boolean equal = false;
                    for (int i = 0; i < keywords.length; ++i) {
                        String headerPattern = "$" + keywords[i];
                        if (fileLine.indexOf(headerPattern) <= -1) continue;
                        equal = this.compareKeywordLines(fileLine, baseLine, keywords);
                        break;
                    }
                    if (!equal) {
                        boolean bl = true;
                        return bl;
                    }
                }
                baseLine = baseReader.readLine();
                fileLine = fileReader.readLine();
            }
            returnValue = baseLine != null || fileLine != null;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
            if (baseReader != null) {
                baseReader.close();
            }
        }
        return returnValue;
    }

    private List<String> normalizeKeywords(String[] keywords) {
        ArrayList<String> keywordsList = new ArrayList<String>();
        for (int i = 0; i < keywords.length; ++i) {
            String kw = keywords[i].toLowerCase().trim();
            if (kw.equals("date") || kw.equals("lastchangeddate")) {
                keywordsList.add("LastChangedDate");
                keywordsList.add("Date");
                continue;
            }
            if (kw.equals("revision") || kw.equals("rev") || kw.equals("lastchangedrevision")) {
                keywordsList.add("LastChangedRevision");
                keywordsList.add("Revision");
                keywordsList.add("Rev");
                continue;
            }
            if (kw.equals("author") || kw.equals("lastchangedby")) {
                keywordsList.add("LastChangedBy");
                keywordsList.add("Author");
                continue;
            }
            if (kw.equals("url") || kw.equals("headurl")) {
                keywordsList.add("HeadURL");
                keywordsList.add("URL");
                continue;
            }
            if (kw.equals("id")) {
                keywordsList.add("Id");
                continue;
            }
            if (kw.equals(VERSION_UNKNOWN)) continue;
            keywordsList.add(keywords[i]);
        }
        return keywordsList;
    }

    private boolean compareKeywordLines(String modifiedLine, String baseLine, String[] keywords) {
        int modifiedIdx = 0;
        for (int fileIdx = 0; fileIdx < baseLine.length(); ++fileIdx) {
            if (baseLine.charAt(fileIdx) == '$') {
                for (int keywordsIdx = 0; keywordsIdx < keywords.length; ++keywordsIdx) {
                    int spaces;
                    String keyword = keywords[keywordsIdx];
                    boolean gotHeader = false;
                    for (int keyIdx = 0; keyIdx < keyword.length(); ++keyIdx) {
                        if (fileIdx + keyIdx + 1 > baseLine.length() - 1 || keyword.charAt(keyIdx) != baseLine.charAt(fileIdx + keyIdx + 1)) {
                            gotHeader = false;
                            break;
                        }
                        gotHeader = true;
                    }
                    if (!gotHeader) continue;
                    boolean isKeyword = true;
                    if (this.checkFollowingString(baseLine, (fileIdx += keyword.length()) + 1, "$")) {
                        ++fileIdx;
                    } else if (this.checkFollowingString(baseLine, fileIdx + 1, ":$")) {
                        fileIdx += 2;
                    } else if (this.checkFollowingString(baseLine, fileIdx + 1, "::")) {
                        spaces = this.getSpacesCount(baseLine, fileIdx + 3);
                        if (spaces <= 0) {
                            return false;
                        }
                        fileIdx += spaces + 3;
                    } else if (this.checkFollowingString(baseLine, fileIdx + 1, ":")) {
                        spaces = this.getSpacesCount(baseLine, fileIdx + 2);
                        if (spaces > 0) {
                            fileIdx += spaces + 2;
                        } else {
                            isKeyword = false;
                        }
                    } else {
                        isKeyword = false;
                    }
                    if (!isKeyword) {
                        fileIdx -= keyword.length();
                        break;
                    }
                    modifiedIdx += keyword.length() + 1;
                    while (++modifiedIdx < modifiedLine.length() && modifiedLine.charAt(modifiedIdx) != '$') {
                    }
                    if (modifiedIdx < modifiedLine.length()) break;
                    return false;
                }
            }
            if (modifiedLine.charAt(modifiedIdx) != baseLine.charAt(fileIdx)) {
                return false;
            }
            if (++modifiedIdx < modifiedLine.length()) continue;
            return fileIdx == baseLine.length() - 1;
        }
        return modifiedIdx == modifiedLine.length() - 2;
    }

    private boolean checkFollowingString(String baseLine, int offset, String str) {
        if (baseLine.length() < offset + str.length()) {
            return false;
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            if (baseLine.charAt(offset + idx) == str.charAt(idx)) continue;
            return false;
        }
        return true;
    }

    private int getSpacesCount(String baseLine, int offset) {
        if (baseLine.length() <= offset) {
            return -1;
        }
        int maxPos = baseLine.length() - offset;
        for (int idx = 0; idx < maxPos; ++idx) {
            char c = baseLine.charAt(offset + idx);
            if (c == ' ') continue;
            if (c == '$') {
                return idx;
            }
            return -1;
        }
        return -1;
    }
}

