/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.MethodDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.RADComponent;
import org.openide.awt.Mnemonics;

public class MethodPicker
extends JPanel {
    static final long serialVersionUID = 7355140527892160804L;
    private JLabel componentLabel;
    private JComboBox componentsCombo;
    private JLabel listLabel;
    private JList methodList;
    private JScrollPane propertiesScrollPane;
    private boolean pickerValid = false;
    private RADComponent[] components;
    private Class<?> requiredType;
    private MethodPickerItem[] items;
    private RADComponent selectedComponent;
    private static Class[] NO_PARAMETERS = new Class[0];

    public MethodPicker(FormModel formModel, RADComponent componentToSelect, Class requiredType) {
        this.requiredType = requiredType;
        this.initComponents();
        List<RADComponent> componentsList = formModel.getComponentList();
        componentsList.sort(new ParametersPicker.ComponentComparator());
        this.components = new RADComponent[componentsList.size()];
        componentsList.toArray(this.components);
        int selIndex = -1;
        for (RADComponent radComp : componentsList) {
            if (componentToSelect != null && componentToSelect == radComp) {
                selIndex = this.componentsCombo.getItemCount();
            }
            if (radComp == formModel.getTopRADComponent()) {
                this.componentsCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                continue;
            }
            this.componentsCombo.addItem(radComp.getName());
        }
        if (selIndex >= 0) {
            this.componentsCombo.setSelectedIndex(selIndex);
        }
        this.updateMethodList();
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)FormUtils.getBundleString("CTL_CW_Component"));
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)FormUtils.getBundleString("CTL_CW_MethodList"));
        this.componentsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Component"));
        this.methodList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodList"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_MethodPicker"));
    }

    public boolean isPickerValid() {
        return this.pickerValid;
    }

    private void setPickerValid(boolean v) {
        boolean old = this.pickerValid;
        this.pickerValid = v;
        this.firePropertyChange("pickerValid", old, this.pickerValid);
    }

    RADComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(RADComponent selectedComponent) {
        if (selectedComponent != null) {
            this.componentsCombo.setSelectedItem(selectedComponent.getName());
        }
    }

    MethodPickerItem getSelectedMethod() {
        if (this.selectedComponent == null || this.methodList.getSelectedIndex() == -1) {
            return null;
        }
        return this.items[this.methodList.getSelectedIndex()];
    }

    void setSelectedMethod(MethodDescriptor selectedMethod) {
        if (selectedMethod == null) {
            this.methodList.setSelectedIndex(-1);
        } else {
            this.methodList.setSelectedValue(FormUtils.getMethodName(selectedMethod), true);
        }
    }

    private void updateMethodList() {
        RADComponent sel = this.getSelectedComponent();
        if (sel == null) {
            this.methodList.setListData(new Object[0]);
            this.methodList.revalidate();
            this.methodList.repaint();
        } else {
            MethodDescriptor[] descs = sel.getBeanInfo().getMethodDescriptors();
            HashMap<String, MethodPickerItem> filtered = new HashMap<String, MethodPickerItem>();
            for (int i = 0; i < descs.length; ++i) {
                if (!this.requiredType.isAssignableFrom(descs[i].getMethod().getReturnType()) || descs[i].getMethod().getParameterTypes().length != 0) continue;
                MethodPickerItem item = this.createItem(descs[i]);
                filtered.put(item.getMethodName(), item);
            }
            if (sel == sel.getFormModel().getTopRADComponent()) {
                String[] names = FormEditor.getFormJavaSource(sel.getFormModel()).getMethodNames(this.requiredType);
                for (int i = 0; i < names.length; ++i) {
                    MethodPickerItem item = this.createItem(names[i]);
                    if (filtered.containsKey(item.getMethodName())) continue;
                    filtered.put(item.getMethodName(), item);
                }
            }
            this.items = new MethodPickerItem[filtered.size()];
            filtered.values().toArray(this.items);
            Arrays.sort(this.items, new Comparator<MethodPickerItem>(){

                @Override
                public int compare(MethodPickerItem o1, MethodPickerItem o2) {
                    return o1.getMethodName().compareTo(o2.getMethodName());
                }
            });
            String[] listItems = new String[this.items.length];
            for (int i = 0; i < listItems.length; ++i) {
                listItems[i] = this.items[i].getMethodName();
            }
            this.methodList.setListData(listItems);
            this.methodList.revalidate();
            this.methodList.repaint();
        }
    }

    private MethodPickerItem createItem(final MethodDescriptor desc) {
        return new MethodPickerItem(){
            private String name;
            {
                this.name = FormUtils.getMethodName(desc);
            }

            @Override
            public String getMethodName() {
                return this.name;
            }

            @Override
            public Class[] getParameterTypes() {
                return desc.getMethod().getParameterTypes();
            }

            @Override
            public MethodDescriptor getMethodDescriptor() {
                return desc;
            }
        };
    }

    private MethodPickerItem createItem(final String methodName) {
        return new MethodPickerItem(){
            private String name;
            {
                this.name = FormUtils.getMethodName(methodName, NO_PARAMETERS);
            }

            @Override
            public String getMethodName() {
                return this.name;
            }

            @Override
            public Class[] getParameterTypes() {
                return NO_PARAMETERS;
            }

            @Override
            public MethodDescriptor getMethodDescriptor() {
                return null;
            }
        };
    }

    private void updateState() {
        if (this.getSelectedComponent() == null || this.getSelectedMethod() == null) {
            this.setPickerValid(false);
        } else {
            this.setPickerValid(this.getSelectedMethod().getParameterTypes().length == 0);
        }
    }

    private void initComponents() {
        this.componentLabel = new JLabel();
        this.componentsCombo = new JComboBox();
        this.listLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.methodList = new JList();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.setLayout(new GridBagLayout());
        this.componentLabel.setLabelFor(this.componentsCombo);
        this.componentLabel.setText("Component:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.componentsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MethodPicker.this.componentsComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 128;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.componentsCombo, gridBagConstraints);
        this.listLabel.setLabelFor(this.methodList);
        this.listLabel.setText("Methods");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MethodPicker.this.methodListValueChanged(evt);
            }
        });
        this.propertiesScrollPane.setViewportView(this.methodList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
    }

    private void methodListValueChanged(ListSelectionEvent evt) {
        this.updateState();
    }

    private void componentsComboItemStateChanged(ItemEvent evt) {
        this.selectedComponent = this.componentsCombo.getSelectedIndex() == -1 ? null : this.components[this.componentsCombo.getSelectedIndex()];
        this.updateMethodList();
    }

    static interface MethodPickerItem {
        public String getMethodName();

        public Class[] getParameterTypes();

        public MethodDescriptor getMethodDescriptor();
    }
}

