/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.PayaraSettings;
import org.netbeans.modules.payara.common.parser.DomainXMLChangeListener;
import org.netbeans.modules.payara.common.utils.ServerUtils;
import org.netbeans.modules.payara.spi.CommandFactory;
import org.netbeans.modules.payara.spi.RegisteredDDCatalog;
import org.netbeans.modules.payara.tooling.PayaraStatus;
import org.netbeans.modules.payara.tooling.admin.CommandSetProperty;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilderProvider;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

public final class PayaraInstanceProvider
implements ServerInstanceProvider,
LookupListener {
    private static final Logger LOGGER = PayaraLogger.get(PayaraInstanceProvider.class);
    public static final String PAYARA_AUTOREGISTERED_INSTANCE = "payara_autoregistered_instance";
    private static final String AUTOINSTANCECOPIED = "autoinstance-copied";
    private static volatile PayaraInstanceProvider payaraProvider;
    public static final String EE6_DEPLOYER_FRAGMENT = "deployer:pfv3ee6";
    public static final String EE6WC_DEPLOYER_FRAGMENT = "deployer:pfv3ee6wc";
    private static final String EE6_INSTANCES_PATH = "/PayaraEE6/Instances";
    private static final String EE6WC_INSTANCES_PATH = "/PayaraEE6WC/Instances";
    public static final Set<String> activeRegistrationSet;
    private final Map<String, PayaraInstance> instanceMap = Collections.synchronizedMap(new HashMap());
    private static final Set<String> activeDisplayNames;
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private final String[] instancesDirNames;
    private final String displayName;
    private final String[] uriFragments;
    private final boolean needsJdk6;
    private final List<String> noPasswordOptions;
    private final CommandFactory cf;
    private final Lookup.Result<RegisteredDDCatalog> lookupResult = Lookups.forPath((String)"Servers/Payara").lookupResult(RegisteredDDCatalog.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PayaraInstanceProvider getProvider() {
        if (payaraProvider != null) {
            return payaraProvider;
        }
        boolean runInit = false;
        Class<PayaraInstanceProvider> clazz = PayaraInstanceProvider.class;
        synchronized (PayaraInstanceProvider.class) {
            if (payaraProvider == null) {
                runInit = true;
                payaraProvider = new PayaraInstanceProvider(new String[]{EE6_DEPLOYER_FRAGMENT, EE6WC_DEPLOYER_FRAGMENT}, new String[]{EE6_INSTANCES_PATH, EE6WC_INSTANCES_PATH}, null, true, new String[]{"--nopassword"}, (property, value) -> new CommandSetProperty(property, value, "DEFAULT={0}={1}"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (runInit) {
                payaraProvider.init();
            }
            return payaraProvider;
        }
    }

    private PayaraInstanceProvider(String[] uriFragments, String[] instancesDirNames, String displayName, boolean needsJdk6, String[] noPasswordOptionsArray, CommandFactory cf) {
        this.instancesDirNames = instancesDirNames;
        this.displayName = displayName;
        this.uriFragments = uriFragments;
        this.needsJdk6 = needsJdk6;
        this.noPasswordOptions = new ArrayList<String>();
        if (null != noPasswordOptionsArray) {
            this.noPasswordOptions.addAll(Arrays.asList(noPasswordOptionsArray));
        }
        this.cf = cf;
        this.lookupResult.allInstances();
        this.lookupResult.addLookupListener((LookupListener)this);
    }

    public void resultChanged(LookupEvent ev) {
        LOGGER.log(Level.FINE, "***** resultChanged fired ********  {0}", this.hashCode());
        RegisteredDDCatalog catalog = PayaraInstanceProvider.getDDCatalog();
        if (null != catalog) {
            catalog.registerRunTimeDDCatalog(this);
        }
        PayaraInstanceProvider.refreshCatalogFromFirstInstance(this, PayaraInstanceProvider.getDDCatalog());
    }

    public static synchronized boolean initialized() {
        return payaraProvider != null;
    }

    private static RegisteredDDCatalog getDDCatalog() {
        return (RegisteredDDCatalog)Lookups.forPath((String)"Servers/Payara").lookup(RegisteredDDCatalog.class);
    }

    private static void refreshCatalogFromFirstInstance(PayaraInstanceProvider pip, RegisteredDDCatalog catalog) {
        PayaraInstance firstInstance = pip.getFirstServerInstance();
        if (null != firstInstance) {
            catalog.refreshRunTimeDDCatalog(pip, firstInstance.getPayaraRoot());
        }
    }

    public static ServerInstance getInstanceByUri(String uri) {
        return PayaraInstanceProvider.getProvider().getInstance(uri);
    }

    public static PayaraInstance getPayaraInstanceByUri(String uri) {
        return PayaraInstanceProvider.getProvider().getPayaraInstance(uri);
    }

    private PayaraInstance getFirstServerInstance() {
        if (!this.instanceMap.isEmpty()) {
            return this.instanceMap.values().iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayaraInstance getPayaraInstance(String uri) {
        Map<String, PayaraInstance> map = this.instanceMap;
        synchronized (map) {
            return this.instanceMap.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerInstance(PayaraInstance si) {
        Map<String, PayaraInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                RegisteredDDCatalog catalog;
                this.instanceMap.put(si.getDeployerUri(), si);
                activeDisplayNames.add(si.getDisplayName());
                if (this.instanceMap.size() == 1 && null != (catalog = PayaraInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, si.getPayaraRoot());
                }
                PayaraInstance.writeInstanceToFile(si);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Could not store Payara server attributes", ex);
            }
        }
        if (!si.isRemote()) {
            DomainXMLChangeListener.registerListener(si);
        }
        this.support.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerInstance(PayaraInstance si) {
        boolean result = false;
        Map<String, PayaraInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.remove(si.getDeployerUri()) != null) {
                RegisteredDDCatalog catalog;
                result = true;
                this.removeInstanceFromFile(si.getDeployerUri());
                activeDisplayNames.remove(si.getDisplayName());
                if (this.instanceMap.isEmpty() && null != (catalog = PayaraInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, null);
                }
            }
        }
        PayaraStatus.remove((PayaraServer)si);
        if (result) {
            ConfigBuilderProvider.destroyBuilder((PayaraServer)si);
            if (!si.isRemote()) {
                DomainXMLChangeListener.unregisterListener(si);
            }
            this.support.fireChange();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookupFor(ServerInstance instance) {
        Map<String, PayaraInstance> map = this.instanceMap;
        synchronized (map) {
            for (PayaraInstance gfInstance : this.instanceMap.values()) {
                if (!gfInstance.getCommonInstance().equals(instance)) continue;
                return gfInstance.getLookup();
            }
            return null;
        }
    }

    public ServerInstanceImplementation getInternalInstance(String uri) {
        return this.instanceMap.get(uri);
    }

    public <T> T getInstanceByCapability(String uri, Class<T> serverFacadeClass) {
        Object result = null;
        PayaraInstance instance = this.instanceMap.get(uri);
        if (instance != null) {
            result = instance.getLookup().lookup(serverFacadeClass);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getInstancesByCapability(Class<T> serverFacadeClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, PayaraInstance> map = this.instanceMap;
        synchronized (map) {
            for (PayaraInstance instance : this.instanceMap.values()) {
                Object serverFacade = instance.getLookup().lookup(serverFacadeClass);
                if (serverFacade == null) continue;
                result.add(serverFacade);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        ArrayList<ServerInstance> result = new ArrayList<ServerInstance>();
        Map<String, PayaraInstance> map = this.instanceMap;
        synchronized (map) {
            for (PayaraInstance instance : this.instanceMap.values()) {
                ServerInstance si = instance.getCommonInstance();
                if (null != si) {
                    result.add(si);
                    continue;
                }
                String message = "invalid commonInstance for " + instance.getDeployerUri();
                LOGGER.log(Level.WARNING, message);
                if (null == instance.getDeployerUri()) continue;
                this.instanceMap.remove(instance.getDeployerUri());
            }
        }
        return result;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public boolean hasServer(String uri) {
        return this.getInstance(uri) != null;
    }

    public ServerInstance getInstance(String uri) {
        ServerInstance rv = null;
        PayaraInstance instance = this.instanceMap.get(uri);
        if (null != instance && null == (rv = instance.getCommonInstance())) {
            String message = "invalid commonInstance for " + instance.getDeployerUri();
            LOGGER.log(Level.WARNING, message);
            if (null != instance.getDeployerUri()) {
                this.instanceMap.remove(instance.getDeployerUri());
            }
        }
        return rv;
    }

    String getInstancesDirFirstName() {
        return this.instancesDirNames[0];
    }

    Collection<PayaraInstance> getInternalInstances() {
        return this.instanceMap.values();
    }

    boolean requiresJdk6OrHigher() {
        return this.needsJdk6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Map<String, PayaraInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                this.loadServerInstances();
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            RegisteredDDCatalog catalog = PayaraInstanceProvider.getDDCatalog();
            if (null != catalog) {
                catalog.registerRunTimeDDCatalog(this);
                PayaraInstanceProvider.refreshCatalogFromFirstInstance(this, catalog);
            }
        }
        for (PayaraInstance gi : this.instanceMap.values()) {
            PayaraInstance.updateModuleSupport(gi);
        }
    }

    private void loadServerInstances() {
        LinkedList<FileObject> installedInstances = new LinkedList<FileObject>();
        for (int j = 0; j < this.instancesDirNames.length; ++j) {
            FileObject[] instanceFOs;
            FileObject dir = ServerUtils.getRepositoryDir(this.instancesDirNames[j], false);
            if (dir == null || (instanceFOs = dir.getChildren()) == null || instanceFOs.length <= 0) continue;
            for (int i = 0; i < instanceFOs.length; ++i) {
                try {
                    if (instanceFOs[i].getName().startsWith(PAYARA_AUTOREGISTERED_INSTANCE)) {
                        installedInstances.add(instanceFOs[i]);
                        continue;
                    }
                    PayaraInstance si = PayaraInstance.readInstanceFromFile(instanceFOs[i], false);
                    if (si != null) {
                        activeDisplayNames.add(si.getDisplayName());
                        continue;
                    }
                    LOGGER.log(Level.FINER, "Unable to create payara instance for {0}", instanceFOs[i].getPath());
                    continue;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
        if (!installedInstances.isEmpty() && null == NbPreferences.forModule(this.getClass()).get(AUTOINSTANCECOPIED, null)) {
            try {
                for (FileObject installedInstance : installedInstances) {
                    PayaraInstance igi = PayaraInstance.readInstanceFromFile(installedInstance, true);
                    activeDisplayNames.add(igi.getDisplayName());
                }
                try {
                    NbPreferences.forModule(this.getClass()).put(AUTOINSTANCECOPIED, "true");
                    NbPreferences.forModule(this.getClass()).flush();
                }
                catch (BackingStoreException ex) {
                    LOGGER.log(Level.INFO, "auto-registered instance may reappear", ex);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private void removeInstanceFromFile(String url) {
        FileObject instanceFO = this.getInstanceFileObject(url);
        if (instanceFO != null && instanceFO.isValid()) {
            try {
                instanceFO.delete();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private FileObject getInstanceFileObject(String url) {
        for (String instancesDirName : this.instancesDirNames) {
            FileObject dir = ServerUtils.getRepositoryDir(instancesDirName, false);
            if (dir == null) continue;
            FileObject[] installedServers = dir.getChildren();
            for (int i = 0; i < installedServers.length; ++i) {
                String val = ServerUtils.getStringAttribute(installedServers[i], "url");
                if (val == null || !val.equals(url) || installedServers[i].getName().startsWith(PAYARA_AUTOREGISTERED_INSTANCE)) continue;
                return installedServers[i];
            }
        }
        return null;
    }

    List<String> getNoPasswordOptions() {
        return this.noPasswordOptions;
    }

    public CommandFactory getCommandFactory() {
        return this.cf;
    }

    static {
        PayaraSettings.toolingLibraryconfig();
        activeRegistrationSet = Collections.synchronizedSet(new HashSet());
        activeDisplayNames = Collections.synchronizedSet(new HashSet());
    }
}

