/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.DecimalStyle;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.logstash.ObjectMappers;
import org.logstash.ackedqueue.Queueable;

@JsonSerialize(using=ObjectMappers.TimestampSerializer.class)
@JsonDeserialize(using=ObjectMappers.TimestampDeserializer.class)
public final class Timestamp
implements Comparable<Timestamp>,
Queueable {
    private static final Logger LOGGER = LogManager.getLogger(Timestamp.class);
    private transient DateTime time;
    private final Instant instant;
    private static final DateTimeFormatter ISO_INSTANT_MILLIS = new DateTimeFormatterBuilder().appendInstant(3).toFormatter().withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter LENIENT_ISO_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalStart().appendOffset("+HHmmss", "Z").optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter().withZone(ZoneId.systemDefault()).withDecimalStyle(DecimalStyle.ofDefaultLocale());

    public Timestamp() {
        this(Clock.systemDefaultZone());
    }

    public Timestamp(String iso8601) {
        this(iso8601, Clock.systemDefaultZone(), Locale.getDefault());
    }

    Timestamp(String iso8601, Clock clock, Locale locale) {
        this.instant = Timestamp.tryParse(iso8601, clock, locale);
    }

    Timestamp(Clock clock) {
        this(clock.instant());
    }

    public Timestamp(long epoch_milliseconds) {
        this(Instant.ofEpochMilli(epoch_milliseconds));
    }

    public Timestamp(Date date) {
        this(date.toInstant());
    }

    public Timestamp(DateTime date) {
        this(date.getMillis());
    }

    public Timestamp(Instant instant) {
        this.instant = instant;
    }

    @Deprecated
    public DateTime getTime() {
        if (this.time == null) {
            this.time = new DateTime(this.instant.toEpochMilli(), DateTimeZone.UTC);
        }
        return this.time;
    }

    public Instant toInstant() {
        return this.instant;
    }

    public static Timestamp now() {
        return new Timestamp();
    }

    public String toString() {
        DateTimeFormatter formatter = this.instant.getNano() == 0 ? ISO_INSTANT_MILLIS : DateTimeFormatter.ISO_INSTANT;
        return formatter.format(this.instant);
    }

    public long toEpochMilli() {
        return this.instant.toEpochMilli();
    }

    public long usec() {
        return this.instant.getNano() / 1000;
    }

    public long nsec() {
        return this.instant.getNano();
    }

    @Override
    public int compareTo(Timestamp other) {
        return this.instant.compareTo(other.instant);
    }

    public boolean equals(Object other) {
        return other instanceof Timestamp && this.instant.equals(((Timestamp)other).instant);
    }

    public int hashCode() {
        return this.instant.hashCode();
    }

    @Override
    public byte[] serialize() {
        return this.toString().getBytes();
    }

    private static Instant tryParse(String iso8601, Clock clock, Locale locale) {
        DateTimeFormatter configuredFormatter = LENIENT_ISO_DATE_TIME_FORMATTER.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).withZone(clock.getZone());
        return Timestamp.tryParse(iso8601, configuredFormatter).or(() -> Timestamp.tryFallbackParse(iso8601, configuredFormatter, f -> f.withDecimalStyle(DecimalStyle.STANDARD))).orElseThrow(() -> new IllegalArgumentException(String.format("Invalid ISO8601 input `%s`", iso8601)));
    }

    private static Optional<Instant> tryParse(String iso8601, DateTimeFormatter configuredFormatter) {
        try {
            return Optional.of(configuredFormatter.parse((CharSequence)iso8601, Instant::from));
        }
        catch (DateTimeParseException e) {
            LOGGER.trace(String.format("Failed to parse `%s` with locale:`%s` and decimal_style:`%s`", iso8601, configuredFormatter.getLocale(), configuredFormatter.getDecimalStyle()), (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<Instant> tryFallbackParse(String iso8601, DateTimeFormatter baseFormatter, UnaryOperator<DateTimeFormatter> formatterTransformer) {
        DateTimeFormatter modifiedFormatter = (DateTimeFormatter)formatterTransformer.apply(baseFormatter);
        if (modifiedFormatter.equals(baseFormatter)) {
            return Optional.empty();
        }
        return Timestamp.tryParse(iso8601, modifiedFormatter);
    }
}

