/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;
import org.apache.derby.shared.common.error.StandardException;

public final class InitPageOperation
extends PhysicalPageOperation {
    protected int nextRecordId;
    protected int initFlag;
    protected int pageFormatId;
    protected long pageOffset;
    protected boolean reuse;
    protected boolean overflowPage;

    InitPageOperation(BasePage page, int flag, int formatid, long offset) throws StandardException {
        super(page);
        this.initFlag = flag;
        this.pageFormatId = formatid;
        this.pageOffset = offset;
        this.nextRecordId = (this.initFlag & 4) == 0 ? page.newRecordId() : 6;
    }

    public InitPageOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.nextRecordId);
        CompressedNumber.writeInt(out, this.initFlag);
        CompressedNumber.writeLong(out, this.pageOffset);
        out.writeInt(this.pageFormatId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.nextRecordId = CompressedNumber.readInt(in);
        this.initFlag = CompressedNumber.readInt(in);
        this.pageOffset = CompressedNumber.readLong(in);
        this.pageFormatId = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 241;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        boolean overflowPage = (this.initFlag & 2) != 0;
        boolean reuse = (this.initFlag & 1) != 0;
        this.page.initPage(instant, (byte)1, this.nextRecordId, overflowPage, reuse);
    }

    @Override
    protected BasePage getPageForRedoRecovery(Transaction xact) throws StandardException {
        BasePage p = super.getPageForRedoRecovery(xact);
        if (p != null) {
            return p;
        }
        p = (BasePage)this.containerHdl.reCreatePageForRedoRecovery(this.pageFormatId, this.getPageId().getPageNumber(), this.pageOffset);
        return p;
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        undoPage.setPageStatus(CLRInstant, (byte)2);
        undoPage.setAuxObject(null);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        this.undoMe(xact, undoPage, CLRInstant, in);
    }

    @Override
    public String toString() {
        boolean overflowPage = (this.initFlag & 2) != 0;
        boolean reuse = (this.initFlag & 1) != 0;
        return super.toString() + "Init Page.  Overflow = " + overflowPage + " reuse " + reuse + " nextRecordId " + this.nextRecordId;
    }
}

