/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.logstash.RubyUtil;
import org.logstash.Timestamp;
import org.logstash.ext.JrubyTimestampExtLibrary;
import org.logstash.jackson.StreamReadConstraintsUtil;
import org.logstash.log.RubyBasicObjectSerializer;

public final class ObjectMappers {
    static final String RUBY_SERIALIZERS_MODULE_ID = "RubySerializers";
    static final StreamReadConstraintsUtil CONFIGURED_STREAM_READ_CONSTRAINTS = StreamReadConstraintsUtil.fromSystemProperties();
    private static final SimpleModule RUBY_SERIALIZERS;
    private static final SimpleModule CBOR_DESERIALIZERS;
    public static final ObjectMapper JSON_MAPPER;
    static String RUBY_BASIC_OBJECT_SERIALIZERS_MODULE_ID;
    public static final ObjectMapper LOG4J_JSON_MAPPER;
    public static final PolymorphicTypeValidator TYPE_VALIDATOR;
    public static final ObjectMapper CBOR_MAPPER;
    public static final JavaType EVENT_MAP_TYPE;

    public static StreamReadConstraintsUtil getConfiguredStreamReadConstraints() {
        return CONFIGURED_STREAM_READ_CONSTRAINTS;
    }

    private ObjectMappers() {
    }

    static {
        CONFIGURED_STREAM_READ_CONSTRAINTS.applyAsGlobalDefault();
        RUBY_SERIALIZERS = new SimpleModule(RUBY_SERIALIZERS_MODULE_ID).addSerializer(RubyString.class, (JsonSerializer)new RubyStringSerializer()).addSerializer(RubySymbol.class, (JsonSerializer)new RubySymbolSerializer()).addSerializer(RubyFloat.class, (JsonSerializer)new RubyFloatSerializer()).addSerializer(RubyBoolean.class, (JsonSerializer)new RubyBooleanSerializer()).addSerializer(RubyFixnum.class, (JsonSerializer)new RubyFixnumSerializer()).addSerializer(RubyBigDecimal.class, (JsonSerializer)new RubyBigDecimalSerializer()).addSerializer(RubyBignum.class, (JsonSerializer)new RubyBignumSerializer()).addSerializer(RubyNil.class, (JsonSerializer)new RubyNilSerializer());
        CBOR_DESERIALIZERS = new SimpleModule("CborRubyDeserializers").addDeserializer(RubyString.class, (JsonDeserializer)new RubyStringDeserializer()).addDeserializer(RubyNil.class, (JsonDeserializer)new RubyNilDeserializer());
        JSON_MAPPER = new ObjectMapper().registerModule((Module)RUBY_SERIALIZERS);
        RUBY_BASIC_OBJECT_SERIALIZERS_MODULE_ID = "RubyBasicObjectSerializers";
        LOG4J_JSON_MAPPER = new Log4jJsonObjectMapper().registerModule((Module)new SimpleModule(RUBY_BASIC_OBJECT_SERIALIZERS_MODULE_ID).addSerializer((JsonSerializer)new RubyBasicObjectSerializer())).registerModule((Module)RUBY_SERIALIZERS);
        TYPE_VALIDATOR = new LaissezFaireSubTypeValidator();
        CBOR_MAPPER = new ObjectMapper((JsonFactory)new CBORFactory().configure(CBORGenerator.Feature.WRITE_MINIMAL_INTS, false).configure(CBORGenerator.Feature.STRINGREF, true)).registerModules(new Module[]{RUBY_SERIALIZERS, CBOR_DESERIALIZERS}).activateDefaultTyping(TYPE_VALIDATOR, ObjectMapper.DefaultTyping.NON_FINAL);
        EVENT_MAP_TYPE = CBOR_MAPPER.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
    }

    private static final class RubyStringSerializer
    extends StdSerializer<RubyString> {
        private static final long serialVersionUID = 7644231054988076676L;

        RubyStringSerializer() {
            super(RubyString.class);
        }

        public void serialize(RubyString value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeString(value.asJavaString());
        }

        public void serializeWithType(RubyString value, JsonGenerator jgen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, RubyString.class, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(jgen, typeId);
            jgen.writeString(value.asJavaString());
            typeSer.writeTypeSuffix(jgen, typeId);
        }
    }

    private static final class RubySymbolSerializer
    extends NonTypedScalarSerializer<RubySymbol> {
        private static final long serialVersionUID = -1822329780680815791L;

        RubySymbolSerializer() {
            super(RubySymbol.class);
        }

        public void serialize(RubySymbol value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeString(value.asJavaString());
        }
    }

    private static final class RubyFloatSerializer
    extends NonTypedScalarSerializer<RubyFloat> {
        private static final long serialVersionUID = 1480899084198662737L;

        RubyFloatSerializer() {
            super(RubyFloat.class);
        }

        public void serialize(RubyFloat value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeNumber(value.getDoubleValue());
        }
    }

    private static final class RubyBooleanSerializer
    extends NonTypedScalarSerializer<RubyBoolean> {
        private static final long serialVersionUID = -8517286459600197793L;

        RubyBooleanSerializer() {
            super(RubyBoolean.class);
        }

        public void serialize(RubyBoolean value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeBoolean(value.isTrue());
        }
    }

    private static final class RubyFixnumSerializer
    extends NonTypedScalarSerializer<RubyFixnum> {
        private static final long serialVersionUID = 13956019593330324L;

        RubyFixnumSerializer() {
            super(RubyFixnum.class);
        }

        public void serialize(RubyFixnum value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeNumber(value.getLongValue());
        }
    }

    private static final class RubyBigDecimalSerializer
    extends NonTypedScalarSerializer<RubyBigDecimal> {
        private static final long serialVersionUID = 1648145951897474391L;

        RubyBigDecimalSerializer() {
            super(RubyBigDecimal.class);
        }

        public void serialize(RubyBigDecimal value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.getBigDecimalValue());
        }
    }

    private static final class RubyBignumSerializer
    extends NonTypedScalarSerializer<RubyBignum> {
        private static final long serialVersionUID = -8986657763732429619L;

        RubyBignumSerializer() {
            super(RubyBignum.class);
        }

        public void serialize(RubyBignum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.getBigIntegerValue());
        }
    }

    private static final class RubyNilSerializer
    extends StdSerializer<RubyNil> {
        private static final long serialVersionUID = 7950663544839173004L;

        RubyNilSerializer() {
            super(RubyNil.class);
        }

        public void serialize(RubyNil value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNull();
        }

        public void serializeWithType(RubyNil value, JsonGenerator jgen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, RubyNil.class, JsonToken.VALUE_NULL);
            typeSer.writeTypePrefix(jgen, typeId);
            jgen.writeNull();
            typeSer.writeTypeSuffix(jgen, typeId);
        }
    }

    public static final class RubyStringDeserializer
    extends StdDeserializer<RubyString> {
        private static final long serialVersionUID = -4444548655926831232L;

        RubyStringDeserializer() {
            super(RubyString.class);
        }

        public RubyString deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return RubyString.newString((Ruby)RubyUtil.RUBY, (String)p.getValueAsString());
        }
    }

    private static final class RubyNilDeserializer
    extends StdDeserializer<RubyNil> {
        private static final long serialVersionUID = 4903218049590688689L;

        RubyNilDeserializer() {
            super(RubyNil.class);
        }

        public RubyNil deserialize(JsonParser p, DeserializationContext ctxt) {
            return (RubyNil)RubyUtil.RUBY.getNil();
        }
    }

    public static final class RubyTimestampSerializer
    extends StdSerializer<JrubyTimestampExtLibrary.RubyTimestamp> {
        private static final long serialVersionUID = -6571512782595488363L;

        RubyTimestampSerializer() {
            super(JrubyTimestampExtLibrary.RubyTimestamp.class);
        }

        public void serialize(JrubyTimestampExtLibrary.RubyTimestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getTimestamp().toString());
        }

        public void serializeWithType(JrubyTimestampExtLibrary.RubyTimestamp value, JsonGenerator jgen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, Timestamp.class, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(jgen, typeId);
            jgen.writeObject((Object)value.getTimestamp());
            typeSer.writeTypeSuffix(jgen, typeId);
        }
    }

    public static final class TimestampDeserializer
    extends StdDeserializer<Timestamp> {
        private static final long serialVersionUID = -8802997528159345068L;

        TimestampDeserializer() {
            super(Timestamp.class);
        }

        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new Timestamp(p.getText());
        }
    }

    public static final class TimestampSerializer
    extends StdSerializer<Timestamp> {
        private static final long serialVersionUID = 5492714135094815910L;

        TimestampSerializer() {
            super(Timestamp.class);
        }

        public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }

        public void serializeWithType(Timestamp value, JsonGenerator jgen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, Timestamp.class, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(jgen, typeId);
            jgen.writeString(value.toString());
            typeSer.writeTypeSuffix(jgen, typeId);
        }
    }

    private static abstract class NonTypedScalarSerializer<T>
    extends StdScalarSerializer<T> {
        private static final long serialVersionUID = -2292969459229763087L;

        NonTypedScalarSerializer(Class<T> t) {
            super(t);
        }

        public final void serializeWithType(T value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, provider);
        }
    }
}

