/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.urls;

import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.keycloak.provider.Provider;
import org.keycloak.urls.UrlType;

public interface HostnameProvider
extends Provider {
    default public String getScheme(UriInfo originalUriInfo, UrlType type) {
        return this.getScheme(originalUriInfo);
    }

    default public String getScheme(UriInfo originalUriInfo) {
        return originalUriInfo.getBaseUri().getScheme();
    }

    default public String getHostname(UriInfo originalUriInfo, UrlType type) {
        return this.getHostname(originalUriInfo);
    }

    default public String getHostname(UriInfo originalUriInfo) {
        return originalUriInfo.getBaseUri().getHost();
    }

    default public int getPort(UriInfo originalUriInfo, UrlType type) {
        return this.getPort(originalUriInfo);
    }

    default public int getPort(UriInfo originalUriInfo) {
        return originalUriInfo.getBaseUri().getPort();
    }

    default public String getContextPath(UriInfo originalUriInfo, UrlType type) {
        return this.getContextPath(originalUriInfo);
    }

    default public String getContextPath(UriInfo originalUriInfo) {
        return originalUriInfo.getBaseUri().getPath();
    }

    @Override
    default public void close() {
    }

    default public URI getBaseUri(UriInfo originalUriInfo, UrlType type) {
        String scheme = this.getScheme(originalUriInfo, type);
        String hostname = this.getHostname(originalUriInfo, type);
        int port = this.getPort(originalUriInfo, type);
        String contextPath = this.getContextPath(originalUriInfo, type);
        return originalUriInfo.getBaseUriBuilder().scheme(scheme).host(hostname).port(port).replacePath(contextPath).build(new Object[0]);
    }
}

