/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.Gatherer;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MultiGather<I, ACC, O>
extends AbstractMultiOperator<I, O> {
    private final Gatherer<I, ACC, O> gatherer;

    public MultiGather(Multi<? extends I> upstream, Gatherer<I, ACC, O> gatherer) {
        super(upstream);
        this.gatherer = gatherer;
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> subscriber) {
        this.upstream.subscribe().withSubscriber(new MultiGatherProcessor(subscriber));
    }

    class MultiGatherProcessor
    extends MultiOperatorProcessor<I, O> {
        private ACC acc;
        private final AtomicLong demand;
        private volatile boolean upstreamHasCompleted;
        private final AtomicInteger drainWip;

        public MultiGatherProcessor(MultiSubscriber<? super O> downstream) {
            super(downstream);
            this.demand = new AtomicLong();
            this.drainWip = new AtomicInteger();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            try {
                this.acc = MultiGather.this.gatherer.accumulator();
                if (this.acc == null) {
                    throw new NullPointerException("The initial accumulator cannot be null");
                }
            }
            catch (Throwable err) {
                this.downstream.onSubscribe(Subscriptions.CANCELLED);
                this.onFailure(err);
                return;
            }
            super.onSubscribe(subscription);
        }

        @Override
        public void request(long numberOfItems) {
            if (numberOfItems <= 0L) {
                this.onFailure(new IllegalArgumentException("The number of items requested must be strictly positive"));
                return;
            }
            if (this.upstream != Subscriptions.CANCELLED) {
                Subscriptions.add(this.demand, numberOfItems);
                if (this.upstreamHasCompleted) {
                    this.drainRemainingElements();
                } else {
                    this.upstream.request(1L);
                }
            }
        }

        @Override
        public void onItem(I item) {
            if (this.upstream == Subscriptions.CANCELLED) {
                return;
            }
            try {
                this.acc = MultiGather.this.gatherer.accumulate(this.acc, item);
                if (this.acc == null) {
                    throw new NullPointerException("The accumulator returned a null value");
                }
                Optional mapping = MultiGather.this.gatherer.extract(this.acc, false);
                if (mapping == null) {
                    throw new NullPointerException("The extractor returned a null value");
                }
                if (mapping.isPresent()) {
                    Gatherer.Extraction result = mapping.get();
                    this.acc = result.nextAccumulator();
                    Object value = result.nextItem();
                    if (this.acc == null) {
                        throw new NullPointerException("The extractor returned a null accumulator value");
                    }
                    if (value == null) {
                        throw new NullPointerException("The extractor returned a null value to emit");
                    }
                    long remaining = this.demand.decrementAndGet();
                    this.downstream.onItem(value);
                    if (remaining > 0L) {
                        this.upstream.request(1L);
                    }
                } else {
                    this.upstream.request(1L);
                }
            }
            catch (Throwable err) {
                this.onFailure(err);
            }
        }

        @Override
        public void onCompletion() {
            if (this.upstream == Subscriptions.CANCELLED) {
                return;
            }
            this.upstreamHasCompleted = true;
            this.drainRemainingElements();
        }

        private void drainRemainingElements() {
            if (this.drainWip.getAndIncrement() > 0) {
                return;
            }
            do {
                long emitted;
                long pending = this.demand.get();
                for (emitted = 0L; emitted < pending; ++emitted) {
                    if (this.upstream == Subscriptions.CANCELLED) {
                        return;
                    }
                    try {
                        Optional mapping = MultiGather.this.gatherer.extract(this.acc, true);
                        if (mapping == null) {
                            throw new NullPointerException("The extractor returned a null value");
                        }
                        if (mapping.isPresent()) {
                            Gatherer.Extraction result = mapping.get();
                            this.acc = result.nextAccumulator();
                            Object value = result.nextItem();
                            if (this.acc == null) {
                                throw new NullPointerException("The extractor returned a null accumulator value");
                            }
                            if (value == null) {
                                throw new NullPointerException("The extractor returned a null value to emit");
                            }
                            this.downstream.onItem(value);
                            continue;
                        }
                        Optional finalValue = MultiGather.this.gatherer.finalize(this.acc);
                        if (finalValue == null) {
                            throw new NullPointerException("The finalizer returned a null value");
                        }
                        this.upstream = Subscriptions.CANCELLED;
                        finalValue.ifPresent(o -> this.downstream.onItem(o));
                        this.downstream.onCompletion();
                        return;
                    }
                    catch (Throwable err) {
                        this.onFailure(err);
                        return;
                    }
                }
                this.demand.addAndGet(-emitted);
            } while (this.drainWip.decrementAndGet() != 0);
        }
    }
}

