/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.UnaryOperator;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PersistentUUIDManagerImpl
implements PersistentUUIDManager {
    private static final Log log = LogFactory.getLog(PersistentUUIDManagerImpl.class);
    private final ConcurrentMap<Address, PersistentUUID> address2uuid = new ConcurrentHashMap<Address, PersistentUUID>();
    private final ConcurrentMap<PersistentUUID, Address> uuid2address = new ConcurrentHashMap<PersistentUUID, Address>();

    @Override
    public void addPersistentAddressMapping(Address address, PersistentUUID persistentUUID) {
        this.address2uuid.put(address, persistentUUID);
        this.uuid2address.put(persistentUUID, address);
    }

    @Override
    public PersistentUUID getPersistentUuid(Address address) {
        return (PersistentUUID)this.address2uuid.get(address);
    }

    @Override
    public Address getAddress(PersistentUUID persistentUUID) {
        return (Address)this.uuid2address.get(persistentUUID);
    }

    @Override
    public void removePersistentAddressMapping(PersistentUUID persistentUUID) {
        if (persistentUUID == null) {
            return;
        }
        Address address = (Address)this.uuid2address.get(persistentUUID);
        if (address != null) {
            this.address2uuid.remove(address);
            this.uuid2address.remove(persistentUUID);
        }
    }

    @Override
    public void removePersistentAddressMapping(Address address) {
        PersistentUUID uuid = (PersistentUUID)this.address2uuid.get(address);
        if (uuid != null) {
            this.uuid2address.remove(uuid);
            this.address2uuid.remove(address);
        }
    }

    @Override
    public List<PersistentUUID> mapAddresses(List<Address> addresses) {
        ArrayList<PersistentUUID> list = new ArrayList<PersistentUUID>(addresses.size());
        for (Address address : addresses) {
            PersistentUUID persistentUUID = (PersistentUUID)this.address2uuid.get(address);
            if (persistentUUID == null) {
                NullPointerException npe = new NullPointerException();
                log.fatal("Cannot find mapping for address " + String.valueOf(address), npe);
                throw npe;
            }
            list.add(persistentUUID);
        }
        return list;
    }

    @Override
    public UnaryOperator<Address> addressToPersistentUUID() {
        return address -> (Address)this.address2uuid.get(address);
    }

    @Override
    public UnaryOperator<Address> persistentUUIDToAddress() {
        return address -> (Address)this.uuid2address.get(address);
    }
}

