/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;

/**
 * The <CODE>XRefFieldLocation</CODE> class contains specific location information
 * within the XREF field of a CodeUnitLocation object.
 */
public class XRefFieldLocation extends CodeUnitLocation {

	/**
	 * Construct a new XRefFieldLocation object.
	 *
	 * @param program the program of the location
	 * @param addr address of the location
	 * appear at more than one group path); may be null
	 * @param componentPath array of indexes for each nested data component;
	 * the index is the data component's index within its parent; may be null 
	 * @param refAddr the reference address at this location.
	 * @param index the index of the XREF in the list of all XREFs at this address.
	 * @param charOffset the character position within the XREF.
	 */
	public XRefFieldLocation(Program program, Address addr, int[] componentPath, Address refAddr,
			int index, int charOffset) {

		super(program, addr, componentPath, refAddr, 0, index, charOffset);
	}

	/**
	 * Creates a cross reference field location. Should only be used for XML restoring.
	 */
	public XRefFieldLocation() {
		super();
	}

	/**
	 * {@return the index of the XREF in the list.}
	 */
	public int getIndex() {
		return getColumn();
	}

	@Override
	public String toString() {
		return super.toString() + ", refAddr=" + refAddr;
	}

}
