/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.action.MenuData;
import ghidra.features.codecompare.decompile.AbstractMatchedCalleeTokensAction;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonView;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionUtility;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Duo;
import java.awt.Component;

public class ApplyCalleeSignatureWithDatatypesFromMatchedTokensAction
extends AbstractMatchedCalleeTokensAction {
    private PluginTool tool;
    public static final String ACTION_NAME = "Function Comparison Apply Callee Signature And Datatypes";

    public ApplyCalleeSignatureWithDatatypesFromMatchedTokensAction(DecompilerCodeComparisonView comparisonProvider, PluginTool tool) {
        super(ACTION_NAME, tool.getName(), comparisonProvider, true);
        this.tool = tool;
        MenuData menuData = new MenuData(new String[]{"Apply From Other Function", "Callee Signature and Data Types"}, null, "A2_ApplyCallee");
        this.setPopupMenuData(menuData);
        this.setHelpLocation(new HelpLocation("FunctionComparison", this.getName()));
    }

    @Override
    protected void doCalleeActionPerformed(Function leftFunction, Function rightFunction) {
        Duo.Side activeSide = this.comparisonProvider.getActiveSide();
        Function activeFunction = activeSide == Duo.Side.LEFT ? leftFunction : rightFunction;
        Function otherFunction = activeSide == Duo.Side.LEFT ? rightFunction : leftFunction;
        Program activeProgram = activeFunction.getProgram();
        try {
            activeProgram.withTransaction("Code Comparison Transfer Callee Signature and Data Types", () -> FunctionUtility.applySignature((Function)activeFunction, (Function)otherFunction, (boolean)false, null));
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Failed to Apply Callee Signature and Data Types", (Object)e.getMessage());
        }
    }
}

