/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractScriptTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptAttributesParser;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.FileNotFoundException;

public class BatchScriptTraceRmiLaunchOffer
extends AbstractScriptTraceRmiLaunchOffer {
    public static final String REM = "::";
    public static final int REM_LEN = "::".length();

    public static BatchScriptTraceRmiLaunchOffer create(TraceRmiLauncherServicePlugin plugin, Program program, File script) throws FileNotFoundException {
        ScriptAttributesParser parser = new ScriptAttributesParser(){

            @Override
            protected boolean ignoreLine(int lineNo, String line) {
                return line.isBlank();
            }

            @Override
            protected String removeDelimiter(String line) {
                String stripped = line.stripLeading();
                if (!stripped.startsWith(BatchScriptTraceRmiLaunchOffer.REM)) {
                    return null;
                }
                return stripped.substring(REM_LEN);
            }
        };
        ScriptAttributesParser.ScriptAttributes attrs = parser.parseFile(script);
        return new BatchScriptTraceRmiLaunchOffer(plugin, program, script, "BATCH_FILE:" + script.getName(), attrs);
    }

    private BatchScriptTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program, File script, String configName, ScriptAttributesParser.ScriptAttributes attrs) {
        super(plugin, program, script, configName, attrs);
    }
}

