/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import docking.options.editor.OptionsEditorPanel;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utility.function.Callback;

public class OptionsPanel
extends JPanel {
    private static final Dimension DEFAULT_PREFERRED_SIZE = new Dimension(650, 350);
    private Map<VTProgramCorrelatorFactory, VTOptions> optionsMap;
    private List<OptionsEditorPanel> optionsEditorPanelList = new ArrayList<OptionsEditorPanel>();
    private Callback statusChangedCallback;
    private JPanel stagingPanel;

    OptionsPanel(Callback statusChangedCallback) {
        super(new BorderLayout());
        this.statusChangedCallback = statusChangedCallback;
        this.stagingPanel = new JPanel(new BorderLayout());
        this.stagingPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JScrollPane scrollPane = new JScrollPane(this.stagingPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.add(scrollPane);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (preferredSize.width < OptionsPanel.DEFAULT_PREFERRED_SIZE.width) {
            return DEFAULT_PREFERRED_SIZE;
        }
        return preferredSize;
    }

    void initialize(List<VTProgramCorrelatorFactory> correlators, Map<VTProgramCorrelatorFactory, VTOptions> map) {
        this.optionsMap = map;
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(30));
        this.optionsEditorPanelList.clear();
        for (VTProgramCorrelatorFactory correlator : correlators) {
            OptionsEditorPanel optionsPanel = this.buildOptionsPanel(correlator);
            if (optionsPanel == null) continue;
            this.optionsEditorPanelList.add(optionsPanel);
            optionsPanel.setOptionsPropertyChangeListener(e -> this.statusChangedCallback.call());
            panel.add((Component)optionsPanel);
        }
        this.stagingPanel.removeAll();
        this.stagingPanel.add((Component)panel, "Center");
        this.stagingPanel.revalidate();
    }

    private OptionsEditorPanel buildOptionsPanel(VTProgramCorrelatorFactory factory) {
        VTOptions options = this.optionsMap.get(factory);
        if (options == null) {
            return null;
        }
        String title = factory.getName() + " Options";
        EditorStateFactory editorStateFactory = new EditorStateFactory();
        List optionNames = options.getLeafOptionNames();
        if (optionNames.isEmpty()) {
            return null;
        }
        Collections.sort(optionNames);
        return new OptionsEditorPanel(title, (Options)options, optionNames, editorStateFactory);
    }

    public boolean hasValidOptions() {
        this.applyOptions();
        for (VTOptions options : this.optionsMap.values()) {
            if (options == null || options.validate()) continue;
            return false;
        }
        return true;
    }

    private void applyOptions() {
        for (OptionsEditorPanel panel : this.optionsEditorPanelList) {
            panel.apply();
        }
    }
}

