/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterChangedListener;
import ghidra.feature.vt.gui.filters.FilterState;
import java.util.HashSet;
import java.util.Set;

public abstract class AncillaryFilter<T>
extends Filter<T> {
    private HashSet<FilterChangedListener> listeners = new HashSet();

    public void addFilterChangedListener(FilterChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeFilterChangedListener(FilterChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void fireStatusChanged(Filter.FilterEditingStatus status) {
        this.fireFilterStateChanged();
    }

    public void fireFilterStateChanged() {
        FilterState state = this.getFilterState();
        Set set = (Set)this.listeners.clone();
        for (FilterChangedListener listener : set) {
            listener.filterStateChanged(state);
        }
    }

    public abstract FilterState getFilterState();

    public abstract void restoreFilterState(FilterState var1);
}

