/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractLinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.C11Lines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C11LinesStartEnd;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13ExtendedInlineeSourceLine;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FileChecksum;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FileRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13InlineeSourceLine;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13LineRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13SectionIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.FileChecksumsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.IlLinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.InlineeLinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.LinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.Module;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FunctionIdMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunctionIdMsType;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.framework.store.LockException;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.util.Msg;
import ghidra.util.SourceFileUtils;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PdbSourceLinesApplicator {
    private DefaultPdbApplicator applicator;
    private AbstractPdb pdb;
    private Program program;
    private MessageLog log;
    private Map<Address, Integer> functionLengthByAddress;
    private SourceFileManager manager;

    public PdbSourceLinesApplicator(DefaultPdbApplicator applicator) {
        Objects.requireNonNull(applicator, "applicator cannot be null");
        this.applicator = applicator;
        this.program = applicator.getProgram();
        Objects.requireNonNull(this.program, "program cannot be null");
        this.pdb = applicator.getPdb();
        Objects.requireNonNull(this.pdb, "pdb cannot be null");
        this.log = applicator.getMessageLog();
        this.functionLengthByAddress = new HashMap<Address, Integer>();
        this.manager = this.program.getSourceFileManager();
    }

    public void setFunctionLength(Address address, int length) {
        this.functionLengthByAddress.put(address, length);
    }

    public void process(TaskMonitor monitor) throws CancelledException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            Msg.info((Object)this, (Object)"PDB: Missing DebugInfo - cannot process line numbers.");
            return;
        }
        if (!this.program.hasExclusiveAccess()) {
            Msg.showWarn((Object)this, null, (String)"Cannot Apply SourceMap Information", (Object)"Exclusive access to the program is required to apply source map information");
            return;
        }
        int numModules = debugInfo.getNumModules();
        monitor.initialize((long)numModules);
        monitor.setMessage("PDB: Importing module function source line information...");
        for (int num = 1; num <= numModules; ++num) {
            monitor.checkCancelled();
            Module module = debugInfo.getModule(num);
            this.processC11Lines(module);
            this.processC13Sections(module);
            monitor.incrementProgress(1L);
        }
    }

    private void processC11Lines(Module module) throws CancelledException {
        ModuleInformation moduleInfo = module.getModuleInformation();
        try {
            C11Lines c11Lines = module.getLineInformation();
            if (c11Lines != null) {
                this.applicator.getPdbApplicatorMetrics().witnessC11Lines();
            }
        }
        catch (PdbException e) {
            this.log.appendMsg("PDB: Failed to process C11Lines due to " + e.getMessage());
            return;
        }
    }

    private void processC11Line(ModuleInformation moduleInfo, C11Lines c11Lines) {
        Msg.info((Object)this, (Object)"PDB: Unimplemented... unable to process C11 Lines");
        int cFile = c11Lines.getNumFiles();
        int cSet = c11Lines.getNumSegments();
        List<Integer> baseSrcFile = c11Lines.getBaseSrcFiles();
        List<C11LinesStartEnd> startEnd = c11Lines.getStartEnd();
        List<Integer> seg = c11Lines.getSegments();
        List<Integer> ccSegs = c11Lines.getPerFileNumSegments();
        List<List<Integer>> baseSrcLines = c11Lines.getPerFileBaseSrcLines();
        List<List<C11LinesStartEnd>> startEnds = c11Lines.getPerFileStartEndRecords();
        List<String> names = c11Lines.getFileNames();
        List<List<Integer>> segmentNumbers = c11Lines.getPerFileSegmentNumbers();
        List<List<List<Long>>> offsets = c11Lines.getPerFilePerSegmentOffsets();
        List<List<List<Integer>>> lineNumbers = c11Lines.getPerFilePerSegmentLineNumbers();
    }

    private void processC13Sections(Module module) throws CancelledException {
        C13SectionIterator<InlineeLinesC13Section> inlineeLinesIterator;
        C13SectionIterator<IlLinesC13Section> ilLinesIterator;
        C13SectionIterator<LinesC13Section> linesIterator;
        C13SectionIterator<FileChecksumsC13Section> c13FileChecksumIterator;
        ModuleInformation moduleInfo = module.getModuleInformation();
        try {
            c13FileChecksumIterator = module.getC13SectionFilteredIterator(FileChecksumsC13Section.class);
            linesIterator = module.getC13SectionFilteredIterator(LinesC13Section.class);
            ilLinesIterator = module.getC13SectionFilteredIterator(IlLinesC13Section.class);
            inlineeLinesIterator = module.getC13SectionFilteredIterator(InlineeLinesC13Section.class);
        }
        catch (PdbException e) {
            this.log.appendMsg("PDB: Failed to process C13Sections due to " + e.getMessage());
            return;
        }
        FileChecksumsC13Section fileChecksumsSection = null;
        while (c13FileChecksumIterator.hasNext()) {
            this.pdb.checkCancelled();
            FileChecksumsC13Section section = (FileChecksumsC13Section)c13FileChecksumIterator.next();
            if (fileChecksumsSection != null) {
                Msg.warn((Object)this, (Object)("More than on FileChecksumC13Section found in module " + moduleInfo.getModuleName()));
                break;
            }
            fileChecksumsSection = section;
        }
        if (fileChecksumsSection == null) {
            return;
        }
        while (linesIterator.hasNext()) {
            this.pdb.checkCancelled();
            LinesC13Section linesSection = (LinesC13Section)linesIterator.next();
            this.processC13FileRecords(moduleInfo, fileChecksumsSection, linesSection, false);
        }
        while (ilLinesIterator.hasNext()) {
            this.pdb.checkCancelled();
            IlLinesC13Section ilLinesSection = (IlLinesC13Section)ilLinesIterator.next();
            this.processC13FileRecords(moduleInfo, fileChecksumsSection, ilLinesSection, true);
        }
        if (inlineeLinesIterator.hasNext()) {
            this.applicator.getPdbApplicatorMetrics().witnessC13InlineeLines();
        }
    }

    private void processC13FileRecords(ModuleInformation moduleInfo, FileChecksumsC13Section fileChecksumsC13Section, AbstractLinesC13Section c13Lines, boolean isIlLines) throws CancelledException {
        List<C13FileRecord> fileRecords = c13Lines.getFileRecords();
        long offCon = c13Lines.getOffCon();
        int segCon = c13Lines.getSegCon();
        for (C13FileRecord fileRecord : fileRecords) {
            this.pdb.checkCancelled();
            int fileId = fileRecord.getFileId();
            SourceFile sourceFile = this.getSourceFile(fileChecksumsC13Section, fileId);
            long lastValue = -1L;
            Long numLines = fileRecord.getNLines();
            List<C13LineRecord> lineRecords = fileRecord.getLineRecords();
            for (int index = numLines.intValue() - 1; index >= 0; --index) {
                FunctionManager functionManager;
                Function function;
                this.pdb.checkCancelled();
                C13LineRecord lineRecord = lineRecords.get(index);
                Long lineNumStart = lineRecord.getLineNumStart();
                long offset = lineRecord.getOffset();
                long actualOffset = offset + offCon;
                Address address = this.applicator.getAddress(segCon, actualOffset);
                if (lastValue == -1L && (function = (functionManager = this.program.getFunctionManager()).getFunctionContaining(address)) != null) {
                    Address functionAddress = function.getEntryPoint();
                    lastValue = this.functionLengthByAddress.getOrDefault(functionAddress, -1).intValue();
                }
                Long length = lastValue - offset;
                length = Long.max(length, 0L);
                lastValue = offset;
                this.applyRecord(sourceFile, address, lineNumStart.intValue(), length.intValue());
            }
        }
    }

    private void processC13InlineeLines(ModuleInformation moduleInfo, FileChecksumsC13Section fileChecksumsC13Section, InlineeLinesC13Section c13InlineeLines) throws CancelledException {
        List<C13InlineeSourceLine> inlineeLines = c13InlineeLines.getInlineeLines();
        for (C13InlineeSourceLine inlineeLine : inlineeLines) {
            this.pdb.checkCancelled();
            int fileId = inlineeLine.getFileId();
            SourceFile sourceFile = this.getSourceFile(fileChecksumsC13Section, fileId);
            Long inlinee = inlineeLine.getInlinee();
            RecordNumber recordNumber = RecordNumber.itemRecordNumber(inlinee.intValue());
            AbstractMsType type = this.applicator.getTypeRecord(recordNumber);
            if (type instanceof FunctionIdMsType) {
                FunctionIdMsType functionId = (FunctionIdMsType)type;
                name = functionId.getName();
                RecordNumber scopeIdRecordNumber = functionId.getScopeIdRecordNumber();
                var16_19 = this.applicator.getTypeRecord(scopeIdRecordNumber);
            } else if (type instanceof MemberFunctionIdMsType) {
                MemberFunctionIdMsType memberFunctionId = (MemberFunctionIdMsType)type;
                name = memberFunctionId.getName();
                RecordNumber parentTypeRecordNumber = memberFunctionId.getParentTypeRecordNumber();
                var16_19 = this.applicator.getTypeRecord(parentTypeRecordNumber);
            }
            long lineNum = inlineeLine.getSourceLineNum();
            if (!(inlineeLine instanceof C13ExtendedInlineeSourceLine)) continue;
            C13ExtendedInlineeSourceLine extendedInlineeLine = (C13ExtendedInlineeSourceLine)inlineeLine;
            int numIds = extendedInlineeLine.getNumExtraFileIds();
            List<Integer> ids = extendedInlineeLine.getExtraFileIds();
            for (int id : ids) {
                SourceFile sourceFile2 = this.getSourceFile(fileChecksumsC13Section, id);
            }
        }
    }

    private SourceFile getSourceFile(FileChecksumsC13Section fileChecksums, int fileId) {
        C13FileChecksum checksumInfo = fileChecksums.getFileChecksumByOffset(fileId);
        Long offsetFilename = checksumInfo.getOffsetFilename();
        String filename = this.pdb.getNameStringFromOffset(offsetFilename.intValue());
        SourceFileIdType idType = switch (checksumInfo.getChecksumTypeValue()) {
            case 0 -> SourceFileIdType.NONE;
            case 1 -> SourceFileIdType.MD5;
            case 2 -> SourceFileIdType.SHA1;
            case 3 -> SourceFileIdType.SHA256;
            default -> SourceFileIdType.UNKNOWN;
        };
        byte[] identifier = checksumInfo.getChecksumBytes();
        SourceFile sourceFile = SourceFileUtils.getSourceFileFromPathString((String)filename, (SourceFileIdType)idType, (byte[])identifier);
        try {
            this.manager.addSourceFile(sourceFile);
        }
        catch (LockException e) {
            throw new AssertionError((Object)"LockException after exclusive access verified!");
        }
        return sourceFile;
    }

    private void applyRecord(SourceFile sourceFile, Address address, int start, int length) {
        if (!address.isMemoryAddress() || start < 0 || length < 0) {
            this.log.appendMsg("PDB", "Invalid source map info: %s, %d, %s, %d".formatted(sourceFile.getPath(), start, address.toString(), length));
            return;
        }
        CodeUnit cu = this.program.getListing().getCodeUnitContaining(address);
        if (cu == null) {
            this.log.appendMsg("PDB", "Skipping source map info (no code unit found at " + String.valueOf(address) + ")");
            return;
        }
        try {
            this.manager.addSourceMapEntry(sourceFile, start, address, (long)length);
        }
        catch (LockException e) {
            throw new AssertException("LockException after exclusive access verified!");
        }
        catch (AddressOverflowException e) {
            this.log.appendMsg("PDB", "AddressOverflow for source map info: %s, %d, %s, %d".formatted(sourceFile.getPath(), start, address.toString(), length));
        }
        catch (IllegalArgumentException e) {
            this.log.appendMsg("PDB", "IllegalArgumentException for source map info: %s, %d, %s, %d".formatted(sourceFile.getPath(), start, address.toString(), length));
        }
        catch (AddressOutOfBoundsException e) {
            this.log.appendMsg("PDB", "AddressOutOfBoundsException for source map info: %s, %d, %s, %d".formatted(sourceFile.getPath(), start, address.toString(), length));
        }
    }
}

