/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolRecords;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DiscardedByLinkMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4411;
    private int discardedVal;
    private DiscardReason discard;
    private long fileId;
    private long firstLineNumber;
    private List<AbstractMsSymbol> symbolList;

    public DiscardedByLinkMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        super(pdb, reader);
        long fields = reader.parseUnsignedIntVal();
        this.discardedVal = (int)(fields & 0xFFL);
        this.discard = DiscardReason.fromValue(this.discardedVal);
        this.fileId = reader.parseUnsignedIntVal();
        this.firstLineNumber = reader.parseUnsignedIntVal();
        byte[] data = reader.parseBytesRemaining();
        PdbByteReader dataReader = new PdbByteReader(data);
        this.symbolList = this.getOrderedSymbols(SymbolRecords.deserializeSymbolRecords(pdb, dataReader));
    }

    private List<AbstractMsSymbol> getOrderedSymbols(Map<Long, AbstractMsSymbol> symbolsByOffset) {
        ArrayList<Long> offsets = new ArrayList<Long>(symbolsByOffset.keySet());
        ArrayList<AbstractMsSymbol> symbols = new ArrayList<AbstractMsSymbol>();
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            symbols.add(symbolsByOffset.get(offset));
        }
        return symbols;
    }

    @Override
    public int getPdbId() {
        return 4411;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: ", this.getSymbolTypeName()));
        if (this.discard == DiscardReason.UNKNOWN) {
            builder.append(String.format("(%02X)", this.discardedVal));
        } else {
            builder.append((Object)this.discard);
        }
        if (this.fileId != -1L) {
            builder.append(String.format(", FileId: %08X", this.fileId));
            builder.append(String.format(", Line: %8d", this.firstLineNumber));
        }
        builder.append("\n");
        for (AbstractMsSymbol symbol : this.symbolList) {
            builder.append(symbol);
            builder.append("\n");
        }
    }

    @Override
    protected String getSymbolTypeName() {
        return "DISCARDED";
    }

    public static enum DiscardReason {
        INVALID("", -1),
        UNKNOWN("Unknown", 0),
        NOT_SELECTED("Not selected", 1),
        NOT_REFERENCED("Not referenced", 2);

        private static final Map<Integer, DiscardReason> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static DiscardReason fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private DiscardReason(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, DiscardReason>();
            for (DiscardReason val : DiscardReason.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

