/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.action;

import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public interface LocationTrackingSpecFactory
extends ExtensionPoint {
    public static LocationTrackingSpec fromConfigName(String name) {
        for (LocationTrackingSpecFactory factory : ClassSearcher.getInstances(LocationTrackingSpecFactory.class)) {
            LocationTrackingSpec spec = factory.parseSpec(name);
            if (spec == null) continue;
            return spec;
        }
        return null;
    }

    public static Map<String, LocationTrackingSpec> allSuggested(PluginTool tool) {
        TreeMap<String, LocationTrackingSpec> all = new TreeMap<String, LocationTrackingSpec>();
        for (LocationTrackingSpecFactory factory : ClassSearcher.getInstances(LocationTrackingSpecFactory.class)) {
            for (LocationTrackingSpec spec : factory.getSuggested(tool)) {
                all.put(spec.getConfigName(), spec);
            }
        }
        return all;
    }

    public List<LocationTrackingSpec> getSuggested(PluginTool var1);

    public LocationTrackingSpec parseSpec(String var1);
}

