/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.proxy;

import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Reference;
import java.util.Objects;

public class VariableProxy
extends ProxyObj<Variable> {
    private Program program;
    private Address locationAddr;
    private Address functionAddr;
    private Address storageAddr;
    private int firstUseOffset;
    private Variable var;
    private int ordinal = -1;
    private boolean isFirst;

    public VariableProxy(ListingModel model, Program program, Address locationAddr, Function fun, Variable var, boolean isFirst) {
        super(model);
        this.program = program;
        this.locationAddr = locationAddr;
        this.var = var;
        this.isFirst = isFirst;
        this.functionAddr = fun.getEntryPoint();
        if (var != null) {
            Varnode firstVarnode;
            if (var instanceof Parameter) {
                this.ordinal = ((Parameter)var).getOrdinal();
            }
            this.storageAddr = (firstVarnode = var.getFirstStorageVarnode()) != null ? firstVarnode.getAddress() : null;
            this.firstUseOffset = var.getFirstUseOffset();
        }
    }

    @Override
    public Variable getObject() {
        try {
            this.var.getName();
            return this.var;
        }
        catch (Exception exception) {
            Variable[] vars;
            if (this.storageAddr == null) {
                return null;
            }
            Listing listing = this.program.getListing();
            Function function = listing.getFunctionAt(this.functionAddr);
            if (function == null) {
                return null;
            }
            if (!this.locationAddr.equals((Object)this.functionAddr)) {
                if (listing.getFunctionAt(this.locationAddr) != null) {
                    return null;
                }
                CodeUnit cu = listing.getCodeUnitAt(this.locationAddr);
                if (!(cu instanceof Data)) {
                    return null;
                }
                Data data = (Data)cu;
                if (!(data.getDataType() instanceof Pointer)) {
                    return null;
                }
                Reference ref = data.getPrimaryReference(0);
                if (ref == null || !ref.getToAddress().equals((Object)this.functionAddr)) {
                    return null;
                }
            }
            if (this.ordinal >= 0) {
                return function.getParameter(this.ordinal);
            }
            for (Variable var2 : vars = function.getLocalVariables()) {
                if (this.firstUseOffset != var2.getFirstUseOffset() || !this.storageAddr.equals((Object)var2.getMinAddress())) continue;
                this.var = var2;
                return this.var;
            }
            return null;
        }
    }

    public Address getLocationAddress() {
        return this.locationAddr;
    }

    public Address getFunctionAddress() {
        return this.functionAddr;
    }

    public Program getProgram() {
        return this.program;
    }

    @Override
    public boolean contains(Address a) {
        Variable v = this.getObject();
        if (v == null) {
            return false;
        }
        return Objects.equals(v.getMinAddress(), a);
    }

    public boolean isFirst() {
        return this.isFirst;
    }
}

