/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExportedSymbolKey
implements StructConverter {
    private int fullHashWord;
    private short nameLength;
    private short hashValue;

    ExportedSymbolKey(BinaryReader reader) throws IOException {
        int value;
        this.fullHashWord = value = reader.readNextInt();
        this.nameLength = (short)(value >> 16);
        this.hashValue = (short)(value & 0xFFFF);
    }

    public int getFullHashWord() {
        return this.fullHashWord;
    }

    public short getNameLength() {
        return this.nameLength;
    }

    public short getHashValue() {
        return this.hashValue;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return new TypedefDataType("ExportedSymbolKey", DWORD);
    }
}

