/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import docking.DialogComponentProvider;
import docking.widgets.button.BrowseButton;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.plugin.core.string.NGramUtils;
import ghidra.app.plugin.core.string.StringTableOptions;
import ghidra.app.plugin.core.string.StringTablePlugin;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SearchStringDialog
extends DialogComponentProvider {
    private IntegerTextField alignField;
    private IntegerTextField minLengthField;
    private JTextField wordModelField;
    private JCheckBox nullTerminateCheckbox;
    private JCheckBox pascalStringsCheckbox;
    private AddressSetView selectedAddressSet;
    private StringTablePlugin plugin;
    private JRadioButton loadedBlocksRB;
    private JRadioButton allBlocksRB;
    private JRadioButton searchSelectionRB;
    private JRadioButton searchAllRB;

    public SearchStringDialog(StringTablePlugin plugin, AddressSetView addressSet) {
        super("Search For Strings");
        this.plugin = plugin;
        this.selectedAddressSet = addressSet;
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.setOkButtonText("Search");
        this.addCancelButton();
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.setHelpLocation(new HelpLocation("Search", "String_Search_Dialog"));
    }

    protected void okCallback() {
        String wordModelFile;
        int minLength = this.minLengthField.getIntValue();
        if (minLength <= 1) {
            this.setStatusText("Please enter a valid minimum search length. Must be > 1");
            return;
        }
        StringTableOptions options = new StringTableOptions();
        options.setAlignment(Math.max(this.alignField.getIntValue(), 1));
        options.setMinStringSize(Math.max(this.minLengthField.getIntValue(), 1));
        options.setNullTerminationRequired(this.nullTerminateCheckbox.isSelected());
        options.setRequirePascal(this.pascalStringsCheckbox.isSelected());
        options.setUseLoadedBlocksOnly(this.loadedBlocksRB.isSelected());
        if (this.searchSelectionRB.isSelected()) {
            options.setAddressSet(this.selectedAddressSet);
        }
        if ((wordModelFile = this.wordModelField.getText()).matches("^\\s*$")) {
            options.setWordModelInitialized(false);
        } else {
            try {
                NGramUtils.startNewSession(wordModelFile, false);
                options.setWordModelInitialized(true);
                options.setWordModelFile(wordModelFile);
            }
            catch (IOException ioe) {
                this.setStatusText("Select a valid model file (e.g., 'StringModel.sng') or leave blank.");
                return;
            }
        }
        this.plugin.createStringsProvider(options);
        this.close();
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel.add(this.buildLeftPanel(), "West");
        panel.add(Box.createHorizontalStrut(10), "Center");
        panel.add(this.buildRightPanel(), "East");
        panel.getAccessibleContext().setAccessibleName("Search String");
        return panel;
    }

    private Component buildLeftPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildOptionsPanelLeft(), "North");
        panel.add(Box.createVerticalStrut(15), "Center");
        panel.add((Component)this.buildMemoryBlocksPanel(), "South");
        panel.getAccessibleContext().setAccessibleName("Memory Block Search");
        return panel;
    }

    private Component buildRightPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildOptionsPanelRight(), "North");
        panel.add(Box.createVerticalStrut(15), "Center");
        panel.add((Component)this.buildSelectionScopePanel(), "South");
        panel.getAccessibleContext().setAccessibleName("Selection Scope Search");
        return panel;
    }

    private JPanel buildOptionsPanelLeft() {
        JPanel panel = new JPanel(new GridLayout(3, 1, 10, 14));
        this.nullTerminateCheckbox = new GCheckBox("Require Null Termination");
        this.nullTerminateCheckbox.getAccessibleContext().setAccessibleName("Require Null Termination");
        this.pascalStringsCheckbox = new GCheckBox("Pascal Strings");
        this.pascalStringsCheckbox.getAccessibleContext().setAccessibleName("Pascal Strings");
        this.nullTerminateCheckbox.setSelected(true);
        panel.add(this.nullTerminateCheckbox);
        panel.add(this.pascalStringsCheckbox);
        panel.getAccessibleContext().setAccessibleName("Options");
        return panel;
    }

    private JPanel buildOptionsPanelRight() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 2));
        GLabel minLengthLabel = new GLabel("Minimum Length: ");
        minLengthLabel.setName("minLen");
        minLengthLabel.getAccessibleContext().setAccessibleName("Minimum Length");
        minLengthLabel.setToolTipText("<html>Searches for valid ascii or ascii unicode strings greater or equal to minimum search length.<br> The null characters are not included in the minimum string length.");
        panel.add((Component)minLengthLabel);
        this.minLengthField = new IntegerTextField(5, 5L);
        this.minLengthField.getComponent().setName("minDefault");
        this.minLengthField.getComponent().getAccessibleContext().setAccessibleName("Minimum Length");
        panel.add(this.minLengthField.getComponent());
        GLabel alignLabel = new GLabel("Alignment: ");
        alignLabel.setName("alignment");
        alignLabel.getAccessibleContext().setAccessibleName("Alignment");
        alignLabel.setToolTipText("<html>Searches for strings that start on the given alignment<br>value. The default alignment is processor dependent.");
        panel.add((Component)alignLabel);
        this.alignField = new IntegerTextField(5, 1L);
        this.alignField.getComponent().setName("alignDefault");
        this.alignField.getComponent().getAccessibleContext().setAccessibleName("Align");
        panel.add(this.alignField.getComponent());
        this.createModelFieldPanel(panel);
        panel.getAccessibleContext().setAccessibleName("Options");
        return panel;
    }

    private void createModelFieldPanel(JPanel panel) {
        GLabel modelLabel = new GLabel("Word Model: ");
        modelLabel.setName("wordModel");
        modelLabel.setToolTipText("<html>Strings Analyzer model used to detect high-confidence words.<br> Model files are built using Ghidra's BuildStringModels class.<br><br>(see help for updating model)");
        panel.add((Component)modelLabel);
        JPanel modelFieldPanel = new JPanel();
        modelFieldPanel.setLayout(new BoxLayout(modelFieldPanel, 0));
        this.wordModelField = new JTextField("StringModel.sng");
        this.wordModelField.setName("modelDefault");
        modelFieldPanel.add(this.wordModelField);
        BrowseButton browseButton = new BrowseButton();
        browseButton.addActionListener(e -> {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)panel);
            chooser.setTitle("Select Word Model File");
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter("sng", "Word File"));
            File selectedFile = chooser.getSelectedFile();
            chooser.dispose();
            if (selectedFile == null) {
                return;
            }
            this.wordModelField.setText(selectedFile.getName());
        });
        modelFieldPanel.add((Component)browseButton);
        panel.add(modelFieldPanel);
    }

    private JPanel buildMemoryBlocksPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Memory Block Types"));
        ButtonGroup memoryBlockGroup = new ButtonGroup();
        this.loadedBlocksRB = new GRadioButton("Loaded Blocks", true);
        this.loadedBlocksRB.getAccessibleContext().setAccessibleName("Loaded Bocks");
        this.allBlocksRB = new GRadioButton("All Blocks", false);
        this.allBlocksRB.getAccessibleContext().setAccessibleName("All Blocks");
        memoryBlockGroup.add(this.loadedBlocksRB);
        memoryBlockGroup.add(this.allBlocksRB);
        this.loadedBlocksRB.setToolTipText(HTMLUtilities.toHTML((String)"Only searches memory blocks that are loaded in a running executable.\n  Ghidra now includes memory blocks for other data such as section headers.\nThis option exludes these other (non-loaded) blocks."));
        this.allBlocksRB.setToolTipText("Searches all memory blocks including blocks that are not actually loaded in a running executable");
        panel.add(this.loadedBlocksRB);
        panel.add(this.allBlocksRB);
        panel.getAccessibleContext().setAccessibleName("Memory Blocks");
        return panel;
    }

    private JPanel buildSelectionScopePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder("Selection Scope"));
        this.searchSelectionRB = new GRadioButton("Search Selection");
        this.searchSelectionRB.getAccessibleContext().setAccessibleName("Search Selection");
        this.searchAllRB = new GRadioButton("Search All");
        this.searchAllRB.getAccessibleContext().setAccessibleName("Search All");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.searchSelectionRB);
        buttonGroup.add(this.searchAllRB);
        this.searchAllRB.setSelected(true);
        this.searchSelectionRB.setSelected(this.hasSelection());
        panel.add(this.searchAllRB);
        panel.add(this.searchSelectionRB);
        this.searchSelectionRB.setEnabled(this.hasSelection());
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new BorderLayout());
        selectionPanel.add((Component)panel, "North");
        selectionPanel.getAccessibleContext().setAccessibleName("Selections Scope");
        return selectionPanel;
    }

    private boolean hasSelection() {
        return this.selectedAddressSet != null && !this.selectedAddressSet.isEmpty();
    }
}

