/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.store.FileIDFactory;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class DBContentHandler<T extends DomainObjectAdapterDB>
implements ContentHandler<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long createFile(DomainObjectAdapterDB domainObj, String contentType, FileSystem fs, String path, String name, TaskMonitor monitor) throws InvalidNameException, CancelledException, IOException {
        DBHandle dbh = domainObj.getDBHandle();
        ManagedBufferFile bf = fs.createDatabase(path, name, FileIDFactory.createFileID(), contentType, dbh.getBufferSize(), SystemUtilities.getUserName(), null);
        long checkoutId = bf.getCheckinID();
        boolean success = false;
        try {
            dbh.saveAs((BufferFile)bf, true, monitor);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    bf.delete();
                }
                catch (IOException iOException) {}
                this.abortCreate(fs, path, name, checkoutId);
            }
        }
        return checkoutId;
    }

    protected void abortCreate(FileSystem fs, String path, String name, long checkoutId) {
        try {
            FolderItem item = fs.getItem(path, name);
            if (item != null) {
                if (checkoutId != -1L) {
                    item.terminateCheckout(checkoutId, false);
                }
                item.delete(-1, SystemUtilities.getUserName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

