/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.selection;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.event.EventListenerList;
import org.jgrapht.Graph;
import org.jungrapht.visualization.selection.MutableSelectedState;

public class VertexEndpointsSelectedEdgeSelectedState<V, E>
implements MutableSelectedState<E> {
    protected Set<E> selected = new LinkedHashSet();
    protected Supplier<Graph<V, E>> graphSupplier;
    protected EventListenerList listenerList = new EventListenerList();

    public VertexEndpointsSelectedEdgeSelectedState(Supplier<Graph<V, E>> graphSupplier, MutableSelectedState<V> selectedVertexState) {
        this.graphSupplier = graphSupplier;
        selectedVertexState.addItemListener(evt -> {
            Graph graph = (Graph)graphSupplier.get();
            this.selected = graph.edgeSet().stream().filter(e -> {
                Object source = graph.getEdgeSource(e);
                Object target = graph.getEdgeTarget(e);
                return selectedVertexState.isSelected(source) && selectedVertexState.isSelected(target);
            }).collect(Collectors.toSet());
        });
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    @Override
    public Set<E> getSelected() {
        return Collections.unmodifiableSet(this.selected);
    }

    @Override
    public boolean isSelected(E t) {
        return this.selected.contains(t);
    }

    @Override
    public boolean select(E element) {
        return false;
    }

    @Override
    public boolean select(E element, boolean fireEvents) {
        return false;
    }

    @Override
    public boolean deselect(E element) {
        return false;
    }

    @Override
    public boolean deselect(E element, boolean fireEvents) {
        return false;
    }

    @Override
    public boolean select(Collection<E> elements) {
        return false;
    }

    @Override
    public boolean select(Collection<E> elements, boolean fireEvents) {
        return false;
    }

    @Override
    public boolean deselect(Collection<E> elements) {
        return false;
    }

    @Override
    public boolean deselect(Collection<E> elements, boolean fireEvents) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public void clear(boolean fireEvents) {
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Object[0];
    }
}

