/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.ListIterator;
import generic.stl.ListNodeSTL;
import generic.stl.ListSTL;

class ReverseListIterator<T>
extends ListIterator<T> {
    ReverseListIterator(ListSTL<T> list, ListNodeSTL<T> root, ListNodeSTL<T> node) {
        super(list, root, node);
    }

    @Override
    public IteratorSTL<T> copy() {
        return new ReverseListIterator<T>(this.list, this.root, this.node);
    }

    @Override
    public boolean isBegin() {
        return this.node == this.root.prev;
    }

    @Override
    public IteratorSTL<T> decrement() {
        if (this.node.prev == this.root) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node.next;
        return this;
    }

    @Override
    public IteratorSTL<T> increment() {
        this.node = this.node.prev;
        return this;
    }

    @Override
    public void insert(T value) {
        ListNodeSTL newNode = new ListNodeSTL(this.node, this.node.next, value);
        this.node.next.prev = newNode;
        this.node.next = newNode;
        this.node = newNode;
        this.list.adjustSize(1);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReverseListIterator other = (ReverseListIterator)obj;
        return this.list == other.list && this.node == other.node;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }
}

