/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen;

import java.util.Iterator;
import java.util.LinkedList;
import nu.xom.jaxen.JaxenException;
import nu.xom.jaxen.expr.DefaultXPathFactory;
import nu.xom.jaxen.expr.Expr;
import nu.xom.jaxen.expr.FilterExpr;
import nu.xom.jaxen.expr.FunctionCallExpr;
import nu.xom.jaxen.expr.LocationPath;
import nu.xom.jaxen.expr.Predicate;
import nu.xom.jaxen.expr.Predicated;
import nu.xom.jaxen.expr.Step;
import nu.xom.jaxen.expr.XPathExpr;
import nu.xom.jaxen.expr.XPathFactory;
import nu.xom.jaxen.saxpath.XPathHandler;

public class JaxenHandler
implements XPathHandler {
    private XPathFactory xpathFactory;
    private XPathExpr xpath;
    protected boolean simplified;
    protected LinkedList stack = new LinkedList();

    public JaxenHandler() {
        this.xpathFactory = new DefaultXPathFactory();
    }

    public void setXPathFactory(XPathFactory xPathFactory) {
        this.xpathFactory = xPathFactory;
    }

    public XPathFactory getXPathFactory() {
        return this.xpathFactory;
    }

    public XPathExpr getXPathExpr() {
        return this.getXPathExpr(true);
    }

    public XPathExpr getXPathExpr(boolean bl) {
        if (bl && !this.simplified) {
            this.xpath.simplify();
            this.simplified = true;
        }
        return this.xpath;
    }

    @Override
    public void startXPath() {
        this.simplified = false;
        this.pushFrame();
    }

    @Override
    public void endXPath() throws JaxenException {
        this.xpath = this.getXPathFactory().createXPath((Expr)this.pop());
        this.popFrame();
    }

    @Override
    public void startPathExpr() {
        this.pushFrame();
    }

    @Override
    public void endPathExpr() throws JaxenException {
        FilterExpr filterExpr;
        LocationPath locationPath;
        if (this.stackSize() == 2) {
            locationPath = (LocationPath)this.pop();
            filterExpr = (FilterExpr)this.pop();
        } else {
            Object object = this.pop();
            if (object instanceof LocationPath) {
                locationPath = (LocationPath)object;
                filterExpr = null;
            } else {
                locationPath = null;
                filterExpr = (FilterExpr)object;
            }
        }
        this.popFrame();
        this.push(this.getXPathFactory().createPathExpr(filterExpr, locationPath));
    }

    @Override
    public void startAbsoluteLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createAbsoluteLocationPath());
    }

    @Override
    public void endAbsoluteLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    @Override
    public void startRelativeLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createRelativeLocationPath());
    }

    @Override
    public void endRelativeLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    protected void endLocationPath() throws JaxenException {
        LocationPath locationPath = (LocationPath)this.peekFrame().removeFirst();
        this.addSteps(locationPath, this.popFrame().iterator());
        this.push(locationPath);
    }

    protected void addSteps(LocationPath locationPath, Iterator iterator) {
        while (iterator.hasNext()) {
            locationPath.addStep((Step)iterator.next());
        }
    }

    @Override
    public void startNameStep(int n, String string, String string2) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createNameStep(n, string, string2));
    }

    @Override
    public void endNameStep() {
        this.endStep();
    }

    @Override
    public void startTextNodeStep(int n) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createTextNodeStep(n));
    }

    @Override
    public void endTextNodeStep() {
        this.endStep();
    }

    @Override
    public void startCommentNodeStep(int n) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createCommentNodeStep(n));
    }

    @Override
    public void endCommentNodeStep() {
        this.endStep();
    }

    @Override
    public void startAllNodeStep(int n) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createAllNodeStep(n));
    }

    @Override
    public void endAllNodeStep() {
        this.endStep();
    }

    @Override
    public void startProcessingInstructionNodeStep(int n, String string) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createProcessingInstructionNodeStep(n, string));
    }

    @Override
    public void endProcessingInstructionNodeStep() {
        this.endStep();
    }

    protected void endStep() {
        Step step = (Step)this.peekFrame().removeFirst();
        this.addPredicates(step, this.popFrame().iterator());
        this.push(step);
    }

    @Override
    public void startPredicate() {
        this.pushFrame();
    }

    @Override
    public void endPredicate() throws JaxenException {
        Predicate predicate = this.getXPathFactory().createPredicate((Expr)this.pop());
        this.popFrame();
        this.push(predicate);
    }

    @Override
    public void startFilterExpr() {
        this.pushFrame();
    }

    @Override
    public void endFilterExpr() throws JaxenException {
        Expr expr = (Expr)this.peekFrame().removeFirst();
        FilterExpr filterExpr = this.getXPathFactory().createFilterExpr(expr);
        Iterator iterator = this.popFrame().iterator();
        this.addPredicates(filterExpr, iterator);
        this.push(filterExpr);
    }

    protected void addPredicates(Predicated predicated, Iterator iterator) {
        while (iterator.hasNext()) {
            predicated.addPredicate((Predicate)iterator.next());
        }
    }

    protected void returnExpr() {
        Expr expr = (Expr)this.pop();
        this.popFrame();
        this.push(expr);
    }

    @Override
    public void startOrExpr() {
    }

    @Override
    public void endOrExpr(boolean bl) throws JaxenException {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createOrExpr(expr2, expr));
        }
    }

    @Override
    public void startAndExpr() {
    }

    @Override
    public void endAndExpr(boolean bl) throws JaxenException {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createAndExpr(expr2, expr));
        }
    }

    @Override
    public void startEqualityExpr() {
    }

    @Override
    public void endEqualityExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createEqualityExpr(expr2, expr, n));
        }
    }

    @Override
    public void startRelationalExpr() {
    }

    @Override
    public void endRelationalExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createRelationalExpr(expr2, expr, n));
        }
    }

    @Override
    public void startAdditiveExpr() {
    }

    @Override
    public void endAdditiveExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createAdditiveExpr(expr2, expr, n));
        }
    }

    @Override
    public void startMultiplicativeExpr() {
    }

    @Override
    public void endMultiplicativeExpr(int n) throws JaxenException {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createMultiplicativeExpr(expr2, expr, n));
        }
    }

    @Override
    public void startUnaryExpr() {
    }

    @Override
    public void endUnaryExpr(int n) throws JaxenException {
        if (n != 0) {
            this.push(this.getXPathFactory().createUnaryExpr((Expr)this.pop(), n));
        }
    }

    @Override
    public void startUnionExpr() {
    }

    @Override
    public void endUnionExpr(boolean bl) throws JaxenException {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createUnionExpr(expr2, expr));
        }
    }

    @Override
    public void number(int n) throws JaxenException {
        this.push(this.getXPathFactory().createNumberExpr(n));
    }

    @Override
    public void number(double d) throws JaxenException {
        this.push(this.getXPathFactory().createNumberExpr(d));
    }

    @Override
    public void literal(String string) throws JaxenException {
        this.push(this.getXPathFactory().createLiteralExpr(string));
    }

    @Override
    public void variableReference(String string, String string2) throws JaxenException {
        this.push(this.getXPathFactory().createVariableReferenceExpr(string, string2));
    }

    @Override
    public void startFunction(String string, String string2) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createFunctionCallExpr(string, string2));
    }

    @Override
    public void endFunction() {
        FunctionCallExpr functionCallExpr = (FunctionCallExpr)this.peekFrame().removeFirst();
        this.addParameters(functionCallExpr, this.popFrame().iterator());
        this.push(functionCallExpr);
    }

    protected void addParameters(FunctionCallExpr functionCallExpr, Iterator iterator) {
        while (iterator.hasNext()) {
            functionCallExpr.addParameter((Expr)iterator.next());
        }
    }

    protected int stackSize() {
        return this.peekFrame().size();
    }

    protected void push(Object object) {
        this.peekFrame().addLast(object);
    }

    protected Object pop() {
        return this.peekFrame().removeLast();
    }

    protected boolean canPop() {
        return this.peekFrame().size() > 0;
    }

    protected void pushFrame() {
        this.stack.addLast(new LinkedList());
    }

    protected LinkedList popFrame() {
        return (LinkedList)this.stack.removeLast();
    }

    protected LinkedList peekFrame() {
        return (LinkedList)this.stack.getLast();
    }
}

