/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.BlockContext;
import scala.concurrent.CanAwait;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.impl.ExecutionContextImpl$;
import scala.runtime.BoxedUnit;

public class ExecutionContextImpl
implements ExecutionContext,
ExecutionContextExecutor {
    private final Executor executor;
    private final Function1<Throwable, BoxedUnit> reporter;

    public static ExecutionContextExecutorService createDefaultExecutorService(Function1<Throwable, BoxedUnit> function1) {
        return ExecutionContextImpl$.MODULE$.createDefaultExecutorService(function1);
    }

    public static ExecutionContextExecutor fromExecutor(Executor executor, Function1<Throwable, BoxedUnit> function1) {
        return ExecutionContextImpl$.MODULE$.fromExecutor(executor, function1);
    }

    public static ExecutionContextExecutorService fromExecutorService(ExecutorService executorService, Function1<Throwable, BoxedUnit> function1) {
        return ExecutionContextImpl$.MODULE$.fromExecutorService(executorService, function1);
    }

    public static Function1<Throwable, BoxedUnit> fromExecutor$default$2() {
        return ExecutionContextImpl$.MODULE$.fromExecutor$default$2();
    }

    public static Function1<Throwable, BoxedUnit> fromExecutorService$default$2() {
        return ExecutionContextImpl$.MODULE$.fromExecutorService$default$2();
    }

    public ExecutionContextImpl(Executor executor, Function1<Throwable, BoxedUnit> reporter) {
        this.executor = executor;
        this.reporter = reporter;
        ExecutionContext.$init$(this);
        Predef$.MODULE$.require(!(executor == null), ExecutionContextImpl::$init$$$anonfun$1);
    }

    @Override
    public ExecutionContext prepare() {
        return ExecutionContext.prepare$(this);
    }

    public final Executor executor() {
        return this.executor;
    }

    public final Function1<Throwable, BoxedUnit> reporter() {
        return this.reporter;
    }

    @Override
    public final void execute(Runnable runnable) {
        this.executor().execute(runnable);
    }

    @Override
    public final void reportFailure(Throwable t) {
        this.reporter().apply(t);
    }

    private static final Object $init$$$anonfun$1() {
        return "Executor must not be null";
    }

    public static final class DefaultThreadFactory
    implements ThreadFactory,
    ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final boolean daemonic;
        private final int maxBlockers;
        private final String prefix;
        private final Thread.UncaughtExceptionHandler uncaught;
        public final Semaphore scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits;

        public DefaultThreadFactory(boolean daemonic, int maxBlockers, String prefix, Thread.UncaughtExceptionHandler uncaught) {
            this.daemonic = daemonic;
            this.maxBlockers = maxBlockers;
            this.prefix = prefix;
            this.uncaught = uncaught;
            Predef$.MODULE$.require(!(prefix == null), this::$init$$$anonfun$2);
            Predef$.MODULE$.require(maxBlockers >= 0, this::$init$$$anonfun$3);
            this.scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits = new Semaphore(maxBlockers);
        }

        public final boolean daemonic() {
            return this.daemonic;
        }

        public final int maxBlockers() {
            return this.maxBlockers;
        }

        public final String prefix() {
            return this.prefix;
        }

        public final Thread.UncaughtExceptionHandler uncaught() {
            return this.uncaught;
        }

        public <T extends Thread> T wire(T thread) {
            thread.setDaemon(this.daemonic());
            thread.setUncaughtExceptionHandler(this.uncaught());
            thread.setName(this.prefix() + "-" + thread.getId());
            return thread;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return this.wire(new Thread(runnable));
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool fjp) {
            return this.wire(new BlockContext(fjp, this){
                private boolean isBlocked;
                private final /* synthetic */ DefaultThreadFactory $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(fjp$1);
                    this.isBlocked = false;
                }

                public final Object blockOn(Function0 thunk, CanAwait permission) {
                    if (Thread.currentThread() == this && !this.isBlocked && this.$outer.scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits.tryAcquire()) {
                        R r;
                        try {
                            ForkJoinPool.ManagedBlocker b = new ForkJoinPool.ManagedBlocker(thunk){
                                private final Function0 thunk$1;
                                private Object result;
                                private boolean done;
                                {
                                    this.thunk$1 = thunk$2;
                                    this.result = null;
                                    this.done = false;
                                }

                                public String toString() {
                                    return Function0.toString$(this);
                                }

                                public byte apply$mcB$sp() {
                                    return Function0.apply$mcB$sp$(this);
                                }

                                public short apply$mcS$sp() {
                                    return Function0.apply$mcS$sp$(this);
                                }

                                public char apply$mcC$sp() {
                                    return Function0.apply$mcC$sp$(this);
                                }

                                public int apply$mcI$sp() {
                                    return Function0.apply$mcI$sp$(this);
                                }

                                public long apply$mcJ$sp() {
                                    return Function0.apply$mcJ$sp$(this);
                                }

                                public float apply$mcF$sp() {
                                    return Function0.apply$mcF$sp$(this);
                                }

                                public double apply$mcD$sp() {
                                    return Function0.apply$mcD$sp$(this);
                                }

                                public void apply$mcV$sp() {
                                    Function0.apply$mcV$sp$(this);
                                }

                                public boolean apply$mcZ$sp() {
                                    return Function0.apply$mcZ$sp$(this);
                                }

                                public final boolean block() {
                                    if (!this.done) {
                                        this.result = this.thunk$1.apply();
                                        this.done = true;
                                    }
                                    return this.isReleasable();
                                }

                                public final boolean isReleasable() {
                                    return this.done;
                                }

                                public final Object apply() {
                                    return this.result;
                                }
                            };
                            this.isBlocked = true;
                            ForkJoinPool.managedBlock(b);
                            r = ((Function0)((Object)b)).apply();
                        }
                        finally {
                            this.isBlocked = false;
                            this.$outer.scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits.release();
                        }
                        return r;
                    }
                    return thunk.apply();
                }
            });
        }

        private final Object $init$$$anonfun$2() {
            return "DefaultThreadFactory.prefix must be non null";
        }

        private final Object $init$$$anonfun$3() {
            return "DefaultThreadFactory.maxBlockers must be greater-or-equal-to 0";
        }
    }
}

