/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class BufferingTest {
    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Double Buffered JComponent with ScrollPane");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(800, 600);
            jFrame.setLocationRelativeTo(null);
            CustomCanvas customCanvas = new CustomCanvas();
            JScrollPane jScrollPane = new JScrollPane(customCanvas);
            jFrame.add(jScrollPane);
            jFrame.setVisible(true);
        });
    }

    static class CustomCanvas
    extends JComponent
    implements ActionListener {
        private Timer timer;
        private int angle = 0;

        public CustomCanvas() {
            this.setDoubleBuffered(true);
            this.setPreferredSize(new Dimension(1600, 1200));
            this.timer = new Timer(16, this);
            this.timer.start();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 200; i < this.getWidth(); i += 400) {
                for (int j = 150; j < this.getHeight(); j += 300) {
                    graphics2D.translate(i, j);
                    graphics2D.rotate(Math.toRadians(this.angle));
                    graphics2D.setColor(Color.BLUE);
                    graphics2D.fillRect(-50, -30, 100, 60);
                    graphics2D.rotate(-Math.toRadians(this.angle));
                    graphics2D.translate(-i, -j);
                }
            }
            graphics2D.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.angle += 2;
            if (this.angle >= 360) {
                this.angle = 0;
            }
            this.repaint();
        }
    }
}

