/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class Context
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Context> _DESERIALIZER = JsonpDeserializer.lazy(Context::buildContextDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Context(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Context(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Context of(Function<Builder, ObjectBuilder<Context>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCategory() {
        return this._kind == Kind.Category;
    }

    public String category() {
        return (String)TaggedUnionUtils.get(this, Kind.Category);
    }

    public boolean isLocation() {
        return this._kind == Kind.Location;
    }

    public GeoLocation location() {
        return (GeoLocation)TaggedUnionUtils.get(this, Kind.Location);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<Context> buildContextDeserializer() {
        return new UnionDeserializer.Builder<Context, Kind, Object>(Context::new, true).addMember(Kind.Category, JsonpDeserializer.stringDeserializer()).addMember(Kind.Location, GeoLocation._DESERIALIZER).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context other = (Context)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Context> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(Context o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<Context> category(String v) {
            this._kind = Kind.Category;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Context> location(GeoLocation v) {
            this._kind = Kind.Location;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Context> location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        @Override
        public Context build() {
            this._checkSingleUse();
            return new Context(this);
        }
    }

    public static enum Kind {
        Category,
        Location;

    }
}

