/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.indexstatemanagement.action.AliasActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.AllocationActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.CloseActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.ConvertIndexToRemoteActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.DeleteActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.ForceMergeActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.IndexPriorityActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.NotificationActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.OpenActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.ReadOnlyActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.ReadWriteActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.ReplicaCountActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.RolloverActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.RollupActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.ShrinkActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.SnapshotActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.StopReplicationActionParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.TransformActionParser;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.ActionParser;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionRetry;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionTimeout;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser;", "", "<init>", "()V", "parsers", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/ActionParser;", "getParsers", "()Ljava/util/List;", "customActionExtensionMap", "", "", "getCustomActionExtensionMap", "()Ljava/util/Map;", "addParser", "", "parser", "extensionName", "fromStreamInput", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "parse", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "totalActions", "", "parseAction", "type", "HOLDER", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nISMActionsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISMActionsParser.kt\norg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1563#2:144\n1634#2,3:145\n295#2,2:148\n295#2,2:151\n1#3:150\n*S KotlinDebug\n*F\n+ 1 ISMActionsParser.kt\norg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser\n*L\n68#1:144\n68#1:145,3\n81#1:148,2\n127#1:151,2\n*E\n"})
public final class ISMActionsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ActionParser> parsers;
    @NotNull
    private final Map<String, String> customActionExtensionMap;
    @NotNull
    private static final Lazy<ISMActionsParser> instance$delegate = LazyKt.lazy(ISMActionsParser::instance_delegate$lambda$4);

    private ISMActionsParser() {
        Object[] objectArray = new ActionParser[]{new AliasActionParser(), new AllocationActionParser(), new CloseActionParser(), new DeleteActionParser(), new ForceMergeActionParser(), new IndexPriorityActionParser(), new NotificationActionParser(), new OpenActionParser(), new ReadOnlyActionParser(), new ReadWriteActionParser(), new ReplicaCountActionParser(), new RollupActionParser(), new RolloverActionParser(), new ShrinkActionParser(), new SnapshotActionParser(), new TransformActionParser(), new StopReplicationActionParser(), new ConvertIndexToRemoteActionParser()};
        this.parsers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.customActionExtensionMap = new LinkedHashMap();
    }

    @NotNull
    public final List<ActionParser> getParsers() {
        return this.parsers;
    }

    @NotNull
    public final Map<String, String> getCustomActionExtensionMap() {
        return this.customActionExtensionMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void addParser(@NotNull ActionParser parser, @NotNull String extensionName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        Iterable $this$map$iv = this.parsers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ActionParser actionParser = (ActionParser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getActionType());
        }
        if (((List)destination$iv$iv).contains(parser.getActionType())) {
            throw new IllegalArgumentException(Companion.getDuplicateActionTypesMessage(parser.getActionType()));
        }
        parser.setCustomAction(true);
        this.parsers.add(parser);
        this.customActionExtensionMap.put(parser.getActionType(), extensionName);
    }

    @NotNull
    public final Action fromStreamInput(@NotNull StreamInput sin) {
        ActionParser parser;
        ActionParser actionParser;
        Object v1;
        ActionRetry configRetry;
        ActionTimeout configTimeout;
        String type;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            String string = sin.readString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            type = string;
            configTimeout = (ActionTimeout)sin.readOptionalWriteable(ActionTimeout::new);
            configRetry = (ActionRetry)sin.readOptionalWriteable(ActionRetry::new);
            Iterable $this$firstOrNull$iv = this.parsers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ActionParser it = (ActionParser)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getActionType(), (Object)type)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((actionParser = (parser = (ActionParser)v1)) == null || (actionParser = actionParser.fromStreamInput(sin)) == null) {
            throw new IllegalArgumentException("Invalid field: [" + type + "] found in Actions.");
        }
        ActionParser action = actionParser;
        action.setConfigTimeout(configTimeout);
        action.setConfigRetry(configRetry);
        return action;
    }

    @NotNull
    public final Action parse(@NotNull XContentParser xcp, int totalActions) {
        Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
        Action action = null;
        ActionTimeout timeout = null;
        ActionRetry retry2 = new ActionRetry(3L, null, null, 6, null);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String type;
            block15: {
                type = xcp.currentName();
                xcp.nextToken();
                String string = type;
                if (string == null) break block15;
                int n = -1;
                switch (string.hashCode()) {
                    case -1349088399: {
                        if (string.equals("custom")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1313911455: {
                        if (string.equals("timeout")) {
                            n = 2;
                        }
                        break;
                    }
                    case 108405416: {
                        if (string.equals("retry")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        timeout = ActionTimeout.Companion.parse(xcp);
                        continue block10;
                    }
                    case 3: {
                        retry2 = ActionRetry.Companion.parse(xcp);
                        continue block10;
                    }
                    case 1: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        String customActionType = xcp.currentName();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNull((Object)customActionType);
                        action = this.parseAction(xcp, totalActions, customActionType);
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        continue block10;
                    }
                }
            }
            Intrinsics.checkNotNull((Object)type);
            action = this.parseAction(xcp, totalActions, type);
        }
        if (action == null) {
            boolean bl = false;
            String string = "Action inside state is null";
            throw new IllegalArgumentException(string.toString());
        }
        action.setConfigTimeout(timeout);
        action.setConfigRetry(retry2);
        return action;
    }

    private final Action parseAction(XContentParser xcp, int totalActions, String type) {
        Object v0;
        Action action;
        block2: {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            action = null;
            Iterable $this$firstOrNull$iv = this.parsers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ActionParser it = (ActionParser)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getActionType(), (Object)type)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ActionParser parser = v0;
        if (parser == null) {
            throw new IllegalArgumentException("Invalid field: [" + type + "] found in Actions.");
        }
        action = parser.fromXContent(xcp, totalActions);
        action.setCustomAction(parser.getCustomAction());
        return action;
    }

    private static final ISMActionsParser instance_delegate$lambda$4() {
        return HOLDER.INSTANCE.getInstance();
    }

    public /* synthetic */ ISMActionsParser(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser$Companion;", "", "<init>", "()V", "instance", "Lorg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser;", "getInstance", "()Lorg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser;", "instance$delegate", "Lkotlin/Lazy;", "getDuplicateActionTypesMessage", "", "actionType", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ISMActionsParser getInstance() {
            Lazy lazy = instance$delegate;
            return (ISMActionsParser)lazy.getValue();
        }

        @NotNull
        public final String getDuplicateActionTypesMessage(@NotNull String actionType) {
            Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
            return "Multiple action parsers attempted to register the same action type [" + actionType + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser$HOLDER;", "", "<init>", "()V", "instance", "Lorg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser;", "getInstance", "()Lorg/opensearch/indexmanagement/indexstatemanagement/ISMActionsParser;", "opensearch-index-management"})
    private static final class HOLDER {
        @NotNull
        public static final HOLDER INSTANCE = new HOLDER();
        @NotNull
        private static final ISMActionsParser instance = new ISMActionsParser(null);

        private HOLDER() {
        }

        @NotNull
        public final ISMActionsParser getInstance() {
            return instance;
        }
    }
}

