/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.XECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class Prov11XDHPublicKey
implements XDHPublicKey,
XECPublicKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricXDHPublicKey baseKey;

    Prov11XDHPublicKey(AsymmetricXDHPublicKey asymmetricXDHPublicKey) {
        this.baseKey = asymmetricXDHPublicKey;
    }

    Prov11XDHPublicKey(byte[] byArray) {
        this.baseKey = new AsymmetricXDHPublicKey(byArray);
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getPublicData() {
        return this.baseKey.getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public AsymmetricXDHPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return KeyUtil.keyToString("Public Key", this.getAlgorithm(), this.baseKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XECPublicKey)) {
            return false;
        }
        XECPublicKey xECPublicKey = (XECPublicKey)object;
        return Arrays.areEqual(xECPublicKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricXDHPublicKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public BigInteger getU() {
        return new BigInteger(1, Arrays.reverse(this.baseKey.getPublicData()));
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.baseKey.getAlgorithm().equals(EdEC.Algorithm.X448)) {
            return NamedParameterSpec.X448;
        }
        return NamedParameterSpec.X25519;
    }
}

