/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.Message;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.BodyStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.ContentStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.StaxUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;

public class MessageStaxUnmarshaller
implements Unmarshaller<Message, StaxUnmarshallerContext> {
    private static MessageStaxUnmarshaller instance;

    @Override
    public Message unmarshall(StaxUnmarshallerContext context) throws Exception {
        Message message = new Message();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return message;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Subject", targetDepth)) {
                    message.setSubject(ContentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Body", targetDepth)) continue;
                message.setBody(BodyStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return message;
    }

    public static MessageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageStaxUnmarshaller();
        }
        return instance;
    }
}

