/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.util.Base64;
import org.apache.lucene.index.SegmentInfo;

public final class NativeMemoryCacheKeyHelper {
    public static final String KEY_DELIMITER = "@";

    private NativeMemoryCacheKeyHelper() {
    }

    public static String constructCacheKey(String vectorIndexFileName, SegmentInfo segmentInfo) {
        String segmentId = Base64.getEncoder().encodeToString(segmentInfo.getId());
        String cacheKey = vectorIndexFileName + KEY_DELIMITER + segmentId;
        return cacheKey;
    }

    public static String extractVectorIndexFileName(String cacheKey) {
        int indexOfDelimiter = cacheKey.lastIndexOf(KEY_DELIMITER);
        if (indexOfDelimiter != -1) {
            String vectorFileName = cacheKey.substring(0, indexOfDelimiter);
            return vectorFileName;
        }
        return null;
    }
}

