/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.xml;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jupnp.xml.CatalogResourceResolver;
import org.jupnp.xml.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXParser {
    public static final URI XML_SCHEMA_NAMESPACE = URI.create("http://www.w3.org/2001/xml.xsd");
    public static final URL XML_SCHEMA_RESOURCE = Thread.currentThread().getContextClassLoader().getResource("org/jupnp/schemas/xml.xsd");
    private final XMLReader xr = this.create();

    public SAXParser() {
        this(null);
    }

    public SAXParser(DefaultHandler handler) {
        if (handler != null) {
            this.xr.setContentHandler(handler);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.xr.setContentHandler(handler);
    }

    protected XMLReader create() {
        try {
            XMLReader xmlReader;
            if (this.getSchemaSources() != null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setSchema(this.createSchema(this.getSchemaSources()));
                xmlReader = factory.newSAXParser().getXMLReader();
            } else {
                xmlReader = XMLReaderFactory.createXMLReader();
            }
            xmlReader.setErrorHandler(this.getErrorHandler());
            return xmlReader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Schema createSchema(Source[] schemaSources) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new CatalogResourceResolver((Map<URI, URL>)new HashMap<URI, URL>(){
                {
                    this.put(XML_SCHEMA_NAMESPACE, XML_SCHEMA_RESOURCE);
                }
            }));
            return schemaFactory.newSchema(schemaSources);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Source[] getSchemaSources() {
        return null;
    }

    protected ErrorHandler getErrorHandler() {
        return new SimpleErrorHandler();
    }

    public void parse(InputSource source) throws ParserException {
        try {
            this.xr.parse(source);
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public static class SimpleErrorHandler
    implements ErrorHandler {
        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }
    }

    public static class Handler<I>
    extends DefaultHandler {
        private final Logger logger = LoggerFactory.getLogger(SAXParser.class);
        protected SAXParser parser;
        protected I instance;
        protected Handler parent;
        protected StringBuilder characters = new StringBuilder();
        protected Attributes attributes;

        public Handler(I instance) {
            this(instance, null, null);
        }

        public Handler(I instance, SAXParser parser) {
            this(instance, parser, null);
        }

        public Handler(I instance, Handler parent) {
            this(instance, parent.getParser(), parent);
        }

        public Handler(I instance, SAXParser parser, Handler parent) {
            this.instance = instance;
            this.parser = parser;
            this.parent = parent;
            if (parser != null) {
                parser.setContentHandler(this);
            }
        }

        public I getInstance() {
            return this.instance;
        }

        public SAXParser getParser() {
            return this.parser;
        }

        public Handler getParent() {
            return this.parent;
        }

        protected void switchToParent() {
            if (this.parser != null && this.parent != null) {
                this.parser.setContentHandler(this.parent);
                this.attributes = null;
            }
        }

        public String getCharacters() {
            return this.characters.toString();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.characters = new StringBuilder();
            this.attributes = new AttributesImpl(attributes);
            this.logger.trace("{} starting: {}", (Object)this.getClass().getSimpleName(), (Object)localName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.characters.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.isLastElement(uri, localName, qName)) {
                this.logger.trace("{}: last element, switching to parent: {}", (Object)this.getClass().getSimpleName(), (Object)localName);
                this.switchToParent();
                return;
            }
            this.logger.trace("{} ending: {}", (Object)this.getClass().getSimpleName(), (Object)localName);
        }

        protected boolean isLastElement(String uri, String localName, String qName) {
            return false;
        }

        protected Attributes getAttributes() {
            return this.attributes;
        }
    }
}

