/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands.help.wikidoc;

import java.io.PrintStream;
import org.apache.karaf.shell.impl.console.commands.help.wikidoc.WikiVisitor;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.shell.support.table.ShellTable;

public class AnsiPrintingWikiVisitor
implements WikiVisitor {
    private PrintStream out;
    private int maxSize;
    private StringBuilder sb = new StringBuilder();
    private String indent;

    public AnsiPrintingWikiVisitor(PrintStream out, int maxSize) {
        this.out = out;
        this.maxSize = maxSize;
    }

    @Override
    public void startPara(int size) {
        StringBuilder indentBuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            indentBuilder.append(' ');
        }
        this.indent = indentBuilder.toString();
    }

    @Override
    public void endPara() {
        if (this.sb.length() > 0) {
            ShellTable table = new ShellTable().noHeaders().separator("").size(this.maxSize - 1);
            table.column("").maxSize(this.indent.length());
            table.column("").wrap();
            table.addRow().addContent(this.indent, this.sb.toString());
            table.print(this.out);
            this.sb.setLength(0);
        } else {
            this.out.println();
        }
    }

    @Override
    public void heading(int level, String header) {
        this.sb.append(SimpleAnsi.INTENSITY_BOLD).append(header).append(SimpleAnsi.INTENSITY_NORMAL);
    }

    @Override
    public void link(String target, String title) {
        this.sb.append(SimpleAnsi.COLOR_YELLOW).append(target).append(SimpleAnsi.COLOR_DEFAULT);
    }

    @Override
    public void enumeration(String text) {
        this.sb.append(" * ").append(SimpleAnsi.COLOR_CYAN).append(text).append(SimpleAnsi.COLOR_DEFAULT).append(" ");
    }

    @Override
    public void text(String text) {
        this.sb.append(text);
    }

    @Override
    public void bold(boolean on) {
        if (on) {
            this.sb.append(SimpleAnsi.INTENSITY_BOLD);
        } else {
            this.sb.append(SimpleAnsi.INTENSITY_NORMAL);
        }
    }
}

